/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer.strategy.crushMapping;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.helix.controller.rebalancer.strategy.crushMapping.ConsistentHashSelector;
import org.apache.helix.controller.rebalancer.topology.InstanceNode;
import org.apache.helix.controller.rebalancer.topology.Node;
import org.apache.helix.controller.rebalancer.topology.Topology;
import org.apache.helix.util.JenkinsHash;

public class ConsistentHashingAdjustmentAlgorithm {
    private static final int MAX_SELETOR_CACHE_SIZE = 1000;
    private static final int SELETOR_CACHE_EXPIRE = 3;
    private JenkinsHash _hashFunction;
    private ConsistentHashSelector _selector;
    Set<Node> _activeInstances = new HashSet<Node>();
    private Map<Node, Node> _faultZoneMap = new HashMap<Node, Node>();
    private Map<Node, Set<String>> _faultZonePartitionMap = new HashMap<Node, Set<String>>();
    private static final LoadingCache<Set<Node>, ConsistentHashSelector> _selectorCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(3L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Set<Node>, ConsistentHashSelector>(){

        public ConsistentHashSelector load(Set<Node> allInstances) {
            return new ConsistentHashSelector(allInstances);
        }
    });

    public ConsistentHashingAdjustmentAlgorithm(Topology topology, Collection<String> activeInstanceNames) throws ExecutionException {
        this._hashFunction = new JenkinsHash();
        HashSet<Node> allInstances = new HashSet<Node>();
        for (Node zone : topology.getFaultZones()) {
            for (Node instance : Topology.getAllLeafNodes(zone)) {
                if (!(instance instanceof InstanceNode)) continue;
                allInstances.add(instance);
                this._faultZoneMap.put(instance, zone);
                if (!this._faultZonePartitionMap.containsKey(zone)) {
                    this._faultZonePartitionMap.put(zone, new HashSet());
                }
                if (!activeInstanceNames.contains(((InstanceNode)instance).getInstanceName())) continue;
                this._activeInstances.add(instance);
            }
        }
        this._selector = (ConsistentHashSelector)_selectorCache.get(allInstances);
    }

    public boolean computeMapping(Map<Node, List<String>> nodeToPartitionMap, int randomSeed) {
        if (this._activeInstances.isEmpty()) {
            return false;
        }
        HashSet<Node> inactiveInstances = new HashSet<Node>();
        HashMap<String, Integer> toBeReassigned = new HashMap<String, Integer>();
        Iterator<Node> nodeIter = nodeToPartitionMap.keySet().iterator();
        while (nodeIter.hasNext()) {
            Node instance = nodeIter.next();
            List<String> partitions = nodeToPartitionMap.get(instance);
            if (!this._activeInstances.contains(instance)) {
                inactiveInstances.add(instance);
                this.addToReAssignPartition(toBeReassigned, partitions);
                partitions.clear();
                nodeIter.remove();
                continue;
            }
            this._faultZonePartitionMap.get(this._faultZoneMap.get(instance)).addAll(partitions);
        }
        for (String partition : new ArrayList(toBeReassigned.keySet())) {
            int remainReplicas = (Integer)toBeReassigned.get(partition);
            HashSet<Node> conflictInstance = new HashSet<Node>();
            block2: for (int index = 0; index < (Integer)toBeReassigned.get(partition); ++index) {
                Iterable<Node> sortedInstances = this._selector.getCircle(this._hashFunction.hash(randomSeed, partition.hashCode(), index));
                Iterator<Node> instanceItr = sortedInstances.iterator();
                while (instanceItr.hasNext() && conflictInstance.size() + inactiveInstances.size() != this._selector.instanceSize) {
                    Node instance = instanceItr.next();
                    if (!this._activeInstances.contains(instance)) {
                        inactiveInstances.add(instance);
                    }
                    if (inactiveInstances.contains(instance) || conflictInstance.contains(instance)) continue;
                    Set<String> faultZonePartitions = this._faultZonePartitionMap.get(this._faultZoneMap.get(instance));
                    if (faultZonePartitions.contains(partition)) {
                        conflictInstance.add(instance);
                        continue;
                    }
                    if (!nodeToPartitionMap.containsKey(instance)) {
                        nodeToPartitionMap.put(instance, new ArrayList());
                    }
                    nodeToPartitionMap.get(instance).add(partition);
                    faultZonePartitions.add(partition);
                    --remainReplicas;
                    continue block2;
                }
            }
            if (remainReplicas == 0) {
                toBeReassigned.remove(partition);
                continue;
            }
            toBeReassigned.put(partition, remainReplicas);
        }
        return toBeReassigned.isEmpty();
    }

    private void addToReAssignPartition(Map<String, Integer> toBeReassigned, List<String> partitions) {
        for (String partition : partitions) {
            if (!toBeReassigned.containsKey(partition)) {
                toBeReassigned.put(partition, 1);
                continue;
            }
            toBeReassigned.put(partition, toBeReassigned.get(partition) + 1);
        }
    }
}

