/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeStatus;
import org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.ReceivedDeletedBlockInfo;
import org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.thirdparty.protobuf.ProtocolStringList;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;
import org.apache.hadoop.util.Preconditions;

public class DatanodeProtocolServerSideTranslatorPB
implements DatanodeProtocolPB {
    private final DatanodeProtocol impl;
    private final int maxDataLength;
    private static final DatanodeProtocolProtos.ErrorReportResponseProto VOID_ERROR_REPORT_RESPONSE_PROTO = DatanodeProtocolProtos.ErrorReportResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto VOID_BLOCK_RECEIVED_AND_DELETE_RESPONSE = DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.ReportBadBlocksResponseProto VOID_REPORT_BAD_BLOCK_RESPONSE = DatanodeProtocolProtos.ReportBadBlocksResponseProto.newBuilder().build();
    private static final DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto VOID_COMMIT_BLOCK_SYNCHRONIZATION_RESPONSE_PROTO = DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto.newBuilder().build();

    public DatanodeProtocolServerSideTranslatorPB(DatanodeProtocol impl, int maxDataLength) {
        this.impl = impl;
        this.maxDataLength = maxDataLength;
    }

    @Override
    public DatanodeProtocolProtos.RegisterDatanodeResponseProto registerDatanode(RpcController controller, DatanodeProtocolProtos.RegisterDatanodeRequestProto request) throws ServiceException {
        DatanodeRegistration registrationResp;
        DatanodeRegistration registration = PBHelper.convert(request.getRegistration());
        try {
            registrationResp = this.impl.registerDatanode(registration);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return DatanodeProtocolProtos.RegisterDatanodeResponseProto.newBuilder().setRegistration(PBHelper.convert(registrationResp)).build();
    }

    @Override
    public DatanodeProtocolProtos.HeartbeatResponseProto sendHeartbeat(RpcController controller, DatanodeProtocolProtos.HeartbeatRequestProto request) throws ServiceException {
        HeartbeatResponse response;
        try {
            StorageReport[] report = PBHelperClient.convertStorageReports(request.getReportsList());
            VolumeFailureSummary volumeFailureSummary = request.hasVolumeFailureSummary() ? PBHelper.convertVolumeFailureSummary(request.getVolumeFailureSummary()) : null;
            response = this.impl.sendHeartbeat(PBHelper.convert(request.getRegistration()), report, request.getCacheCapacity(), request.getCacheUsed(), request.getXmitsInProgress(), request.getXceiverCount(), request.getFailedVolumes(), volumeFailureSummary, request.getRequestFullBlockReportLease(), PBHelper.convertSlowPeerInfo(request.getSlowPeersList()), PBHelper.convertSlowDiskInfo(request.getSlowDisksList()));
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.HeartbeatResponseProto.Builder builder = DatanodeProtocolProtos.HeartbeatResponseProto.newBuilder();
        DatanodeCommand[] cmds = response.getCommands();
        if (cmds != null) {
            for (int i = 0; i < cmds.length; ++i) {
                if (cmds[i] == null) continue;
                builder.addCmds(PBHelper.convert(cmds[i]));
            }
        }
        builder.setHaStatus(PBHelper.convert(response.getNameNodeHaState()));
        RollingUpgradeStatus rollingUpdateStatus = response.getRollingUpdateStatus();
        if (rollingUpdateStatus != null) {
            HdfsProtos.RollingUpgradeStatusProto rus = PBHelperClient.convertRollingUpgradeStatus((RollingUpgradeStatus)rollingUpdateStatus);
            builder.setRollingUpgradeStatusV2(rus);
            if (!rollingUpdateStatus.isFinalized()) {
                builder.setRollingUpgradeStatus(rus);
            }
        }
        builder.setFullBlockReportLeaseId(response.getFullBlockReportLeaseId());
        builder.setIsSlownode(response.getIsSlownode());
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReportResponseProto blockReport(RpcController controller, DatanodeProtocolProtos.BlockReportRequestProto request) throws ServiceException {
        DatanodeCommand cmd = null;
        StorageBlockReport[] report = new StorageBlockReport[request.getReportsCount()];
        int index = 0;
        for (DatanodeProtocolProtos.StorageBlockReportProto s : request.getReportsList()) {
            BlockListAsLongs blocks;
            if (s.hasNumberOfBlocks()) {
                int num = (int)s.getNumberOfBlocks();
                Preconditions.checkState((s.getBlocksCount() == 0 ? 1 : 0) != 0, (Object)"cannot send both blocks list and buffers");
                blocks = BlockListAsLongs.decodeBuffers(num, s.getBlocksBuffersList(), this.maxDataLength);
            } else {
                blocks = BlockListAsLongs.decodeLongs(s.getBlocksList(), this.maxDataLength);
            }
            report[index++] = new StorageBlockReport(PBHelperClient.convert((HdfsProtos.DatanodeStorageProto)s.getStorage()), blocks);
        }
        try {
            cmd = this.impl.blockReport(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), report, request.hasContext() ? PBHelper.convert(request.getContext()) : null);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.BlockReportResponseProto.Builder builder = DatanodeProtocolProtos.BlockReportResponseProto.newBuilder();
        if (cmd != null) {
            builder.setCmd(PBHelper.convert(cmd));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.CacheReportResponseProto cacheReport(RpcController controller, DatanodeProtocolProtos.CacheReportRequestProto request) throws ServiceException {
        DatanodeCommand cmd = null;
        try {
            cmd = this.impl.cacheReport(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), request.getBlocksList());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        DatanodeProtocolProtos.CacheReportResponseProto.Builder builder = DatanodeProtocolProtos.CacheReportResponseProto.newBuilder();
        if (cmd != null) {
            builder.setCmd(PBHelper.convert(cmd));
        }
        return builder.build();
    }

    @Override
    public DatanodeProtocolProtos.BlockReceivedAndDeletedResponseProto blockReceivedAndDeleted(RpcController controller, DatanodeProtocolProtos.BlockReceivedAndDeletedRequestProto request) throws ServiceException {
        List<DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto> sBlocks = request.getBlocksList();
        StorageReceivedDeletedBlocks[] info = new StorageReceivedDeletedBlocks[sBlocks.size()];
        for (int i = 0; i < sBlocks.size(); ++i) {
            DatanodeProtocolProtos.StorageReceivedDeletedBlocksProto sBlock = sBlocks.get(i);
            List<DatanodeProtocolProtos.ReceivedDeletedBlockInfoProto> list = sBlock.getBlocksList();
            ReceivedDeletedBlockInfo[] rdBlocks = new ReceivedDeletedBlockInfo[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                rdBlocks[j] = PBHelper.convert(list.get(j));
            }
            info[i] = sBlock.hasStorage() ? new StorageReceivedDeletedBlocks(PBHelperClient.convert((HdfsProtos.DatanodeStorageProto)sBlock.getStorage()), rdBlocks) : new StorageReceivedDeletedBlocks(new DatanodeStorage(sBlock.getStorageUuid()), rdBlocks);
        }
        try {
            this.impl.blockReceivedAndDeleted(PBHelper.convert(request.getRegistration()), request.getBlockPoolId(), info);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_BLOCK_RECEIVED_AND_DELETE_RESPONSE;
    }

    @Override
    public DatanodeProtocolProtos.ErrorReportResponseProto errorReport(RpcController controller, DatanodeProtocolProtos.ErrorReportRequestProto request) throws ServiceException {
        try {
            this.impl.errorReport(PBHelper.convert(request.getRegistartion()), request.getErrorCode(), request.getMsg());
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_ERROR_REPORT_RESPONSE_PROTO;
    }

    @Override
    public HdfsServerProtos.VersionResponseProto versionRequest(RpcController controller, HdfsServerProtos.VersionRequestProto request) throws ServiceException {
        NamespaceInfo info;
        try {
            info = this.impl.versionRequest();
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return HdfsServerProtos.VersionResponseProto.newBuilder().setInfo(PBHelper.convert(info)).build();
    }

    @Override
    public DatanodeProtocolProtos.ReportBadBlocksResponseProto reportBadBlocks(RpcController controller, DatanodeProtocolProtos.ReportBadBlocksRequestProto request) throws ServiceException {
        List<HdfsProtos.LocatedBlockProto> lbps = request.getBlocksList();
        LocatedBlock[] blocks = new LocatedBlock[lbps.size()];
        for (int i = 0; i < lbps.size(); ++i) {
            blocks[i] = PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)lbps.get(i));
        }
        try {
            this.impl.reportBadBlocks(blocks);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_REPORT_BAD_BLOCK_RESPONSE;
    }

    @Override
    public DatanodeProtocolProtos.CommitBlockSynchronizationResponseProto commitBlockSynchronization(RpcController controller, DatanodeProtocolProtos.CommitBlockSynchronizationRequestProto request) throws ServiceException {
        List<HdfsProtos.DatanodeIDProto> dnprotos = request.getNewTaragetsList();
        DatanodeID[] dns = new DatanodeID[dnprotos.size()];
        for (int i = 0; i < dnprotos.size(); ++i) {
            dns[i] = PBHelperClient.convert((HdfsProtos.DatanodeIDProto)dnprotos.get(i));
        }
        ProtocolStringList sidprotos = request.getNewTargetStoragesList();
        String[] storageIDs = sidprotos.toArray(new String[sidprotos.size()]);
        try {
            this.impl.commitBlockSynchronization(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)request.getBlock()), request.getNewGenStamp(), request.getNewLength(), request.getCloseFile(), request.getDeleteBlock(), dns, storageIDs);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
        return VOID_COMMIT_BLOCK_SYNCHRONIZATION_RESPONSE_PROTO;
    }
}

