/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.conf;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HBase"})
@InterfaceStability.Unstable
public class ConfServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String FORMAT_JSON = "json";
    private static final String FORMAT_XML = "xml";
    private static final String FORMAT_PARAM = "format";
    private static final List<String> MASK_PROPERTIES = ImmutableList.of((Object)"password", (Object)"secret", (Object)"superuser");
    static final String MASKED = "<masked>";

    private Configuration getConfFromContext() {
        Configuration conf = (Configuration)this.getServletContext().getAttribute("hbase.conf");
        assert (conf != null);
        return conf;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!HttpServer.isInstrumentationAccessAllowed(this.getServletContext(), request, response)) {
            return;
        }
        String format = request.getParameter(FORMAT_PARAM);
        if (null == format) {
            format = FORMAT_XML;
        }
        if (FORMAT_XML.equals(format)) {
            response.setContentType("text/xml; charset=utf-8");
        } else if (FORMAT_JSON.equals(format)) {
            response.setContentType("application/json; charset=utf-8");
        }
        PrintWriter out = response.getWriter();
        try {
            ConfServlet.writeResponse(this.getConfFromContext(), out, format);
        }
        catch (BadFormatException bfe) {
            response.sendError(400, bfe.getMessage());
        }
        ((Writer)out).close();
    }

    static void writeResponse(Configuration conf, Writer out, String format) throws IOException, BadFormatException {
        Configuration maskedConf = ConfServlet.mask(conf);
        if (FORMAT_JSON.equals(format)) {
            Configuration.dumpConfiguration((Configuration)maskedConf, (Writer)out);
        } else if (FORMAT_XML.equals(format)) {
            maskedConf.writeXml(out);
        } else {
            throw new BadFormatException("Bad format: " + format);
        }
    }

    static Configuration mask(Configuration conf) {
        Configuration maskedConf = new Configuration(conf);
        block0: for (Map.Entry entry : maskedConf) {
            String key = (String)entry.getKey();
            for (String maskProperty : MASK_PROPERTIES) {
                if (!key.toLowerCase().contains(maskProperty)) continue;
                maskedConf.set(key, MASKED);
                continue block0;
            }
        }
        return maskedConf;
    }

    public static class BadFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BadFormatException(String msg) {
            super(msg);
        }
    }
}

