/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ZKAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(ZKAuthentication.class);

    private ZKAuthentication() {
    }

    public static void loginServer(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKAuthentication.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.serverconfig", "zookeeper-server-keytab-kerberos");
    }

    public static void loginClient(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        ZKAuthentication.login(conf, keytabFileKey, userNameKey, hostname, "zookeeper.sasl.clientconfig", "zookeeper-client-keytab-kerberos");
    }

    private static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname, String loginContextProperty, String loginContextName) throws IOException {
        if (!ZKAuthentication.isSecureZooKeeper(conf)) {
            return;
        }
        if (System.getProperty("java.security.auth.login.config") != null) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            LOG.warn("no keytab specified for: {}", (Object)keytabFileKey);
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal((String)principalConfig, (String)hostname);
        JaasConfiguration jaasConf = new JaasConfiguration(loginContextName, principalName, keytabFilename);
        javax.security.auth.login.Configuration.setConfiguration(jaasConf);
        System.setProperty(loginContextProperty, loginContextName);
    }

    public static boolean isSecureZooKeeper(Configuration conf) {
        try {
            javax.security.auth.login.Configuration testConfig = javax.security.auth.login.Configuration.getConfiguration();
            if (testConfig.getAppConfigurationEntry("Client") == null && testConfig.getAppConfigurationEntry("zookeeper-client-keytab-kerberos") == null && testConfig.getAppConfigurationEntry("zookeeper-server-keytab-kerberos") == null && conf.get("hbase.zookeeper.client.kerberos.principal") == null && conf.get("hbase.zookeeper.server.kerberos.principal") == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return "kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication"));
    }

    private static class JaasConfiguration
    extends javax.security.auth.login.Configuration {
        private static final Logger LOG = LoggerFactory.getLogger(JaasConfiguration.class);
        public static final String SERVER_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-server-keytab-kerberos";
        public static final String CLIENT_KEYTAB_KERBEROS_CONFIG_NAME = "zookeeper-client-keytab-kerberos";
        private static final Map<String, String> BASIC_JAAS_OPTIONS = new HashMap<String, String>();
        private static final Map<String, String> KEYTAB_KERBEROS_OPTIONS;
        private static final AppConfigurationEntry KEYTAB_KERBEROS_LOGIN;
        private static final AppConfigurationEntry[] KEYTAB_KERBEROS_CONF;
        private javax.security.auth.login.Configuration baseConfig;
        private final String loginContextName;
        private final boolean useTicketCache;
        private final String keytabFile;
        private final String principal;

        public JaasConfiguration(String loginContextName, String principal, String keytabFile) {
            this(loginContextName, principal, keytabFile, keytabFile == null || keytabFile.length() == 0);
        }

        private JaasConfiguration(String loginContextName, String principal, String keytabFile, boolean useTicketCache) {
            try {
                this.baseConfig = javax.security.auth.login.Configuration.getConfiguration();
            }
            catch (SecurityException e) {
                this.baseConfig = null;
            }
            this.loginContextName = loginContextName;
            this.useTicketCache = useTicketCache;
            this.keytabFile = keytabFile;
            this.principal = principal;
            LOG.info("JaasConfiguration loginContextName={} principal={} useTicketCache={} keytabFile={}", new Object[]{loginContextName, principal, useTicketCache, keytabFile});
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
            if (this.loginContextName.equals(appName)) {
                if (!this.useTicketCache) {
                    KEYTAB_KERBEROS_OPTIONS.put("keyTab", this.keytabFile);
                    KEYTAB_KERBEROS_OPTIONS.put("useKeyTab", "true");
                }
                KEYTAB_KERBEROS_OPTIONS.put("principal", this.principal);
                KEYTAB_KERBEROS_OPTIONS.put("useTicketCache", this.useTicketCache ? "true" : "false");
                return KEYTAB_KERBEROS_CONF;
            }
            if (this.baseConfig != null) {
                return this.baseConfig.getAppConfigurationEntry(appName);
            }
            return null;
        }

        static {
            String jaasEnvVar = System.getenv("HBASE_JAAS_DEBUG");
            if ("true".equalsIgnoreCase(jaasEnvVar)) {
                BASIC_JAAS_OPTIONS.put("debug", "true");
            }
            KEYTAB_KERBEROS_OPTIONS = new HashMap<String, String>();
            KEYTAB_KERBEROS_OPTIONS.put("doNotPrompt", "true");
            KEYTAB_KERBEROS_OPTIONS.put("storeKey", "true");
            KEYTAB_KERBEROS_OPTIONS.put("refreshKrb5Config", "true");
            KEYTAB_KERBEROS_OPTIONS.putAll(BASIC_JAAS_OPTIONS);
            KEYTAB_KERBEROS_LOGIN = new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KEYTAB_KERBEROS_OPTIONS);
            KEYTAB_KERBEROS_CONF = new AppConfigurationEntry[]{KEYTAB_KERBEROS_LOGIN};
        }
    }
}

