/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class JVMClusterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(JVMClusterUtil.class);

    public static RegionServerThread createRegionServerThread(Configuration c, Class<? extends HRegionServer> hrsc, int index) throws IOException {
        HRegionServer server;
        try {
            Constructor<? extends HRegionServer> ctor = hrsc.getConstructor(Configuration.class);
            ctor.setAccessible(true);
            server = ctor.newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of RegionServer: " + hrsc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new RegionServerThread(server, index);
    }

    public static MasterThread createMasterThread(Configuration c, Class<? extends HMaster> hmc, int index) throws IOException {
        HMaster server;
        try {
            server = hmc.getConstructor(Configuration.class).newInstance(c);
        }
        catch (InvocationTargetException ite) {
            Throwable target = ite.getTargetException();
            throw new RuntimeException("Failed construction of Master: " + hmc.toString() + (target.getCause() != null ? target.getCause().getMessage() : ""), target);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        c.set("hbase.masters", Preconditions.checkNotNull(server.getServerName().getAddress()).toString());
        return new MasterThread(server, index);
    }

    private static MasterThread findActiveMaster(List<MasterThread> masters) {
        for (MasterThread t : masters) {
            if (!t.master.isActiveMaster()) continue;
            return t;
        }
        return null;
    }

    public static String startup(List<MasterThread> masters, List<RegionServerThread> regionservers) throws IOException {
        Configuration configuration = null;
        if (masters == null || masters.isEmpty()) {
            return null;
        }
        for (MasterThread masterThread : masters) {
            configuration = masterThread.getMaster().getConfiguration();
            masterThread.start();
        }
        int startTimeout = configuration != null ? Integer.parseInt(configuration.get("hbase.master.start.timeout.localHBaseCluster", "30000")) : 30000;
        JVMClusterUtil.waitForEvent(startTimeout, "active", () -> JVMClusterUtil.findActiveMaster(masters) != null);
        if (regionservers != null) {
            for (RegionServerThread t : regionservers) {
                t.start();
            }
        }
        int n = configuration != null ? Integer.parseInt(configuration.get("hbase.master.init.timeout.localHBaseCluster", "200000")) : 200000;
        JVMClusterUtil.waitForEvent(n, "initialized", () -> {
            MasterThread t = JVMClusterUtil.findActiveMaster(masters);
            return t != null && t.master.isInitialized();
        });
        return JVMClusterUtil.findActiveMaster(masters).master.getServerName().toString();
    }

    private static void waitForEvent(long millis, String action, Supplier<Boolean> check) throws InterruptedIOException {
        long end = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(millis);
        while (!check.get().booleanValue()) {
            if (System.nanoTime() > end) {
                String msg = "Master not " + action + " after " + millis + "ms";
                Threads.printThreadInfo(System.out, "Thread dump because: " + msg);
                throw new RuntimeException(msg);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
        }
        return;
    }

    public static void shutdown(List<MasterThread> masters, List<RegionServerThread> regionservers) {
        LOG.debug("Shutting down HBase Cluster");
        if (masters != null) {
            MasterThread activeMaster = null;
            for (MasterThread t : masters) {
                if (t.master.isStopped()) continue;
                if (!t.master.isActiveMaster()) {
                    try {
                        t.master.stopMaster();
                    }
                    catch (IOException e) {
                        LOG.error("Exception occurred while stopping master", (Throwable)e);
                    }
                    LOG.info("Stopped backup Master {} is stopped: {}", (Object)t.master.hashCode(), (Object)t.master.isStopped());
                    continue;
                }
                if (activeMaster != null) {
                    LOG.warn("Found more than 1 active master, hash {}", (Object)activeMaster.master.hashCode());
                }
                activeMaster = t;
                LOG.debug("Found active master hash={}, stopped={}", (Object)t.master.hashCode(), (Object)t.master.isStopped());
            }
            if (activeMaster != null) {
                try {
                    activeMaster.master.shutdown();
                }
                catch (IOException e) {
                    LOG.error("Exception occurred in HMaster.shutdown()", (Throwable)e);
                }
            }
        }
        boolean wasInterrupted = false;
        long maxTime = EnvironmentEdgeManager.currentTime() + 30000L;
        if (regionservers != null) {
            for (RegionServerThread t : regionservers) {
                t.getRegionServer().stop("Shutdown requested");
            }
            for (RegionServerThread t : regionservers) {
                long now = EnvironmentEdgeManager.currentTime();
                if (!t.isAlive() || wasInterrupted || now >= maxTime) continue;
                try {
                    t.join(maxTime - now);
                }
                catch (InterruptedException e) {
                    LOG.info("Got InterruptedException on shutdown - not waiting anymore on region server ends", (Throwable)e);
                    wasInterrupted = true;
                }
            }
            for (int i = 0; i < 100; ++i) {
                boolean atLeastOneLiveServer = false;
                for (RegionServerThread t : regionservers) {
                    if (!t.isAlive()) continue;
                    atLeastOneLiveServer = true;
                    try {
                        LOG.warn("RegionServerThreads remaining, give one more chance before interrupting");
                        t.join(1000L);
                    }
                    catch (InterruptedException e) {
                        wasInterrupted = true;
                    }
                }
                if (!atLeastOneLiveServer) break;
                for (RegionServerThread t : regionservers) {
                    if (!t.isAlive()) continue;
                    LOG.warn("RegionServerThreads taking too long to stop, interrupting; thread dump if > 3 attempts: i=" + i);
                    if (i > 3) {
                        Threads.printThreadInfo(System.out, "Thread dump " + t.getName());
                    }
                    t.interrupt();
                }
            }
        }
        if (masters != null) {
            for (MasterThread t : masters) {
                while (t.master.isAlive() && !wasInterrupted) {
                    try {
                        Threads.threadDumpingIsAlive(t.master);
                    }
                    catch (InterruptedException e) {
                        LOG.info("Got InterruptedException on shutdown - not waiting anymore on master ends", (Throwable)e);
                        wasInterrupted = true;
                    }
                }
            }
        }
        LOG.info("Shutdown of " + (masters != null ? Integer.valueOf(masters.size()) : "0") + " master(s) and " + (regionservers != null ? Integer.valueOf(regionservers.size()) : "0") + " regionserver(s) " + (wasInterrupted ? "interrupted" : "complete"));
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static class MasterThread
    extends Thread {
        private final HMaster master;

        public MasterThread(HMaster m3, int index) {
            super((Runnable)m3, "M:" + index + ";" + m3.getServerName().toShortString());
            this.master = m3;
        }

        public HMaster getMaster() {
            return this.master;
        }
    }

    public static class RegionServerThread
    extends Thread {
        private final HRegionServer regionServer;

        public RegionServerThread(HRegionServer r, int index) {
            super((Runnable)r, "RS:" + index + ";" + r.getServerName().toShortString());
            this.regionServer = r;
        }

        public HRegionServer getRegionServer() {
            return this.regionServer;
        }

        public void waitForServerOnline() {
            this.regionServer.waitForServerOnline();
        }
    }
}

