/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.joni;

import org.apache.hadoop.hbase.shaded.org.jcodings.Encoding;
import org.apache.hadoop.hbase.shaded.org.joni.Regex;
import org.apache.hadoop.hbase.shaded.org.joni.Syntax;
import org.apache.hadoop.hbase.shaded.org.joni.UnsetAddrList;
import org.apache.hadoop.hbase.shaded.org.joni.WarnCallback;
import org.apache.hadoop.hbase.shaded.org.joni.ast.EncloseNode;
import org.apache.hadoop.hbase.shaded.org.joni.ast.Node;
import org.apache.hadoop.hbase.shaded.org.joni.exception.InternalException;

public final class ScanEnvironment {
    public int option;
    final int caseFoldFlag;
    public final Encoding enc;
    public final Syntax syntax;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int backrefedMem;
    public final WarnCallback warnings;
    int numCall;
    UnsetAddrList unsetAddrList;
    public int numMem;
    int numNamed;
    public EncloseNode[] memNodes;
    int numCombExpCheck;
    int combExpMaxRegNum;
    int currMaxRegNum;
    boolean hasRecursion;
    private int warningsFlag;
    int numPrecReadNotNodes;
    Node[] precReadNotNodes;

    ScanEnvironment(Regex regex, Syntax syntax, WarnCallback warnings) {
        this.syntax = syntax;
        this.warnings = warnings;
        this.option = regex.options;
        this.caseFoldFlag = regex.caseFoldFlag;
        this.enc = regex.enc;
    }

    int addMemEntry() {
        if (this.numMem >= Short.MAX_VALUE) {
            throw new InternalException("too many capture groups are specified");
        }
        if (this.numMem++ == 0) {
            this.memNodes = new EncloseNode[8];
        } else if (this.numMem >= this.memNodes.length) {
            EncloseNode[] tmp = new EncloseNode[this.memNodes.length << 1];
            System.arraycopy(this.memNodes, 0, tmp, 0, this.memNodes.length);
            this.memNodes = tmp;
        }
        return this.numMem;
    }

    void setMemNode(int num, EncloseNode node) {
        if (this.numMem < num) {
            throw new InternalException("internal parser error (bug)");
        }
        this.memNodes[num] = node;
    }

    void pushPrecReadNotNode(Node node) {
        ++this.numPrecReadNotNodes;
        if (this.precReadNotNodes == null) {
            this.precReadNotNodes = new Node[8];
        } else if (this.numPrecReadNotNodes >= this.precReadNotNodes.length) {
            Node[] tmp = new Node[this.precReadNotNodes.length << 1];
            System.arraycopy(this.precReadNotNodes, 0, tmp, 0, this.precReadNotNodes.length);
            this.precReadNotNodes = tmp;
        }
        this.precReadNotNodes[this.numPrecReadNotNodes - 1] = node;
    }

    void popPrecReadNotNode(Node node) {
        if (this.precReadNotNodes != null && this.precReadNotNodes[this.numPrecReadNotNodes - 1] == node) {
            this.precReadNotNodes[this.numPrecReadNotNodes - 1] = null;
            --this.numPrecReadNotNodes;
        }
    }

    Node currentPrecReadNotNode() {
        if (this.numPrecReadNotNodes > 0) {
            return this.precReadNotNodes[this.numPrecReadNotNodes - 1];
        }
        return null;
    }

    int convertBackslashValue(int c) {
        if (this.syntax.opEscControlChars()) {
            switch (c) {
                case 110: {
                    return 10;
                }
                case 116: {
                    return 9;
                }
                case 114: {
                    return 13;
                }
                case 102: {
                    return 12;
                }
                case 97: {
                    return 7;
                }
                case 98: {
                    return 8;
                }
                case 101: {
                    return 27;
                }
                case 118: {
                    if (!this.syntax.op2EscVVtab()) break;
                    return 11;
                }
                default: {
                    if ((97 > c || c > 122) && (65 > c || c > 90)) break;
                    this.unknownEscWarn(String.valueOf((char)c));
                }
            }
        }
        return c;
    }

    void ccEscWarn(String s2) {
        if (this.warnings != WarnCallback.NONE && this.syntax.warnCCOpNotEscaped() && this.syntax.backSlashEscapeInCC()) {
            this.warnings.warn("character class has '" + s2 + "' without escape");
        }
    }

    void unknownEscWarn(String s2) {
        if (this.warnings != WarnCallback.NONE) {
            this.warnings.warn("Unknown escape \\" + s2 + " is ignored");
        }
    }

    void closeBracketWithoutEscapeWarn(String s2) {
        if (this.warnings != WarnCallback.NONE && this.syntax.warnCCOpNotEscaped()) {
            this.warnings.warn("regular expression has '" + s2 + "' without escape");
        }
    }

    void ccDuplicateWarn() {
        if (this.syntax.warnCCDup() && (this.warningsFlag & 0x4000000) == 0) {
            this.warningsFlag |= 0x4000000;
        }
    }
}

