/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.agrona.collections;

import java.util.function.Consumer;
import java.util.function.LongFunction;

public final class LongLruCache<E>
implements AutoCloseable {
    private static final long serialVersionUID = 8349342109370417432L;
    private final int capacity;
    private final LongFunction<E> factory;
    private final Consumer<E> closer;
    private final long[] keys;
    private final Object[] values;
    private int size;

    public LongLruCache(int capacity, LongFunction<E> factory, Consumer<E> closer) {
        this.capacity = capacity;
        this.factory = factory;
        this.closer = closer;
        this.keys = new long[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    public E lookup(long key) {
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            if (this.keys[i] != key) continue;
            Object value = this.values[i];
            this.makeMostRecent(key, value, i);
            return (E)value;
        }
        E value = this.factory.apply(key);
        if (value != null) {
            if (size == this.capacity) {
                this.closer.accept(this.values[size - 1]);
            } else {
                this.size = ++size;
            }
            this.makeMostRecent(key, value, size - 1);
        }
        return value;
    }

    private void makeMostRecent(long key, Object value, int fromIndex) {
        for (int i = fromIndex; i > 0; --i) {
            this.keys[i] = this.keys[i - 1];
            this.values[i] = this.values[i - 1];
        }
        this.keys[0] = key;
        this.values[0] = value;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        for (int i = 0; i < this.size; ++i) {
            this.closer.accept(this.values[i]);
        }
    }
}

