/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionRemoteProcedureBase;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CloseRegionProcedure
extends RegionRemoteProcedureBase {
    private ServerName assignCandidate;

    public CloseRegionProcedure() {
    }

    public CloseRegionProcedure(TransitRegionStateProcedure parent, RegionInfo region, ServerName targetServer, ServerName assignCandidate) {
        super(parent, region, targetServer);
        this.assignCandidate = assignCandidate;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_UNASSIGN;
    }

    @Override
    public RemoteProcedureDispatcher.RemoteOperation newRemoteOperation(MasterProcedureEnv env) {
        return new RSProcedureDispatcher.RegionCloseOperation(this, this.region, this.getProcId(), this.assignCandidate, env.getMasterServices().getMasterActiveTime());
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.CloseRegionProcedureStateData.Builder builder = MasterProcedureProtos.CloseRegionProcedureStateData.newBuilder();
        if (this.assignCandidate != null) {
            builder.setAssignCandidate(ProtobufUtil.toServerName(this.assignCandidate));
        }
        serializer.serialize(builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.CloseRegionProcedureStateData data = serializer.deserialize(MasterProcedureProtos.CloseRegionProcedureStateData.class);
        if (data.hasAssignCandidate()) {
            this.assignCandidate = ProtobufUtil.toServerName(data.getAssignCandidate());
        }
    }

    @Override
    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getCloseProcMetrics();
    }

    @Override
    protected void checkTransition(RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode, long seqId) throws UnexpectedStateException {
        if (transitionCode != RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED) {
            throw new UnexpectedStateException("Received report unexpected " + transitionCode + " transition, " + regionNode.toShortString() + ", " + this + ", expected CLOSED.");
        }
    }

    @Override
    protected void updateTransitionWithoutPersistingToMeta(MasterProcedureEnv env, RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode, long seqId) throws IOException {
        assert (transitionCode == RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED);
        env.getAssignmentManager().regionClosedWithoutPersistingToMeta(regionNode);
    }

    @Override
    protected void restoreSucceedState(AssignmentManager am, RegionStateNode regionNode, long seqId) throws IOException {
        if (regionNode.getState() == RegionState.State.CLOSED) {
            return;
        }
        am.regionClosedWithoutPersistingToMeta(regionNode);
    }
}

