/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.AllowPartialScanResultCache;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ScanResultCache;
import org.apache.hadoop.hbase.client.TestBatchScanResultCache;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, ClientTests.class})
public class TestAllowPartialScanResultCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAllowPartialScanResultCache.class);
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private AllowPartialScanResultCache resultCache;

    @Before
    public void setUp() {
        this.resultCache = new AllowPartialScanResultCache();
    }

    @After
    public void tearDown() {
        this.resultCache.clear();
        this.resultCache = null;
    }

    @Test
    public void test() throws IOException {
        Assert.assertSame((Object)ScanResultCache.EMPTY_RESULT_ARRAY, (Object)this.resultCache.addAndGet(ScanResultCache.EMPTY_RESULT_ARRAY, false));
        Assert.assertSame((Object)ScanResultCache.EMPTY_RESULT_ARRAY, (Object)this.resultCache.addAndGet(ScanResultCache.EMPTY_RESULT_ARRAY, true));
        Cell[] cells1 = TestBatchScanResultCache.createCells(CF, 1, 10);
        Cell[] cells2 = TestBatchScanResultCache.createCells(CF, 2, 10);
        Result[] results1 = this.resultCache.addAndGet(new Result[]{Result.create((Cell[])Arrays.copyOf(cells1, 5), null, (boolean)false, (boolean)true)}, false);
        Assert.assertEquals((long)1L, (long)results1.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results1[0].getRow()));
        Assert.assertEquals((long)5L, (long)results1[0].rawCells().length);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results1[0].getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
        Result[] results2 = this.resultCache.addAndGet(new Result[]{Result.create((Cell[])Arrays.copyOfRange(cells1, 1, 10), null, (boolean)false, (boolean)true)}, false);
        Assert.assertEquals((long)1L, (long)results2.length);
        Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results2[0].getRow()));
        Assert.assertEquals((long)5L, (long)results2[0].rawCells().length);
        for (int i = 5; i < 10; ++i) {
            Assert.assertEquals((long)1L, (long)Bytes.toInt((byte[])results2[0].getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
        Result[] results3 = this.resultCache.addAndGet(new Result[]{Result.create((Cell[])cells1), Result.create((Cell[])cells2)}, false);
        Assert.assertEquals((long)1L, (long)results3.length);
        Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results3[0].getRow()));
        Assert.assertEquals((long)10L, (long)results3[0].rawCells().length);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)2L, (long)Bytes.toInt((byte[])results3[0].getValue(CF, Bytes.toBytes((String)("cq" + i)))));
        }
    }
}

