/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.deviceframework;

import java.util.Set;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.Device;
import org.apache.hadoop.yarn.server.nodemanager.api.deviceplugin.DevicePlugin;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.NodeResourceUpdaterPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceResourceUpdaterImpl
extends NodeResourceUpdaterPlugin {
    static final Logger LOG = LoggerFactory.getLogger(DeviceResourceUpdaterImpl.class);
    private String resourceName;
    private DevicePlugin devicePlugin;

    public DeviceResourceUpdaterImpl(String resourceName, DevicePlugin devicePlugin) {
        this.devicePlugin = devicePlugin;
        this.resourceName = resourceName;
    }

    @Override
    public void updateConfiguredResource(Resource res) throws YarnException {
        LOG.info(this.resourceName + " plugin update resource ");
        Set<Device> devices = null;
        try {
            devices = this.devicePlugin.getDevices();
        }
        catch (Exception e) {
            throw new YarnException("Exception thrown from plugin's getDevices" + e.getMessage());
        }
        if (null == devices) {
            LOG.warn(this.resourceName + " plugin failed to discover resource ( null value got).");
            return;
        }
        res.setResourceValue(this.resourceName, (long)devices.size());
    }
}

