/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RegionScannerAsResultScanner
implements ResultScanner {
    private static final Logger LOG = LoggerFactory.getLogger(RegionScannerAsResultScanner.class);
    private final RegionScanner scanner;
    private boolean moreRows = true;
    private final List<Cell> cells = new ArrayList<Cell>();

    RegionScannerAsResultScanner(RegionScanner scanner) {
        this.scanner = scanner;
    }

    public boolean renewLease() {
        return true;
    }

    public Result next() throws IOException {
        block2: {
            if (!this.moreRows) {
                return null;
            }
            do {
                this.moreRows = this.scanner.next(this.cells);
                if (!this.cells.isEmpty()) break block2;
            } while (this.moreRows);
            return null;
        }
        Result result = Result.create(this.cells);
        this.cells.clear();
        return result;
    }

    public ScanMetrics getScanMetrics() {
        return null;
    }

    public void close() {
        try {
            this.scanner.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close scanner", (Throwable)e);
        }
    }
}

