/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class ModifyTableDescriptorProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.ModifyTableDescriptorState> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyTableDescriptorProcedure.class);
    private TableName tableName;
    private TableDescriptor modifiedTableDescriptor;

    protected ModifyTableDescriptorProcedure() {
    }

    protected ModifyTableDescriptorProcedure(MasterProcedureEnv env, TableName tableName) {
        super(env);
        this.tableName = Objects.requireNonNull(tableName);
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    protected abstract Optional<TableDescriptor> modify(MasterProcedureEnv var1, TableDescriptor var2) throws IOException;

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableDescriptorState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        try {
            switch (state) {
                case MODIFY_TABLE_DESCRIPTOR_PREPARE: {
                    TableDescriptor current = env.getMasterServices().getTableDescriptors().get(this.tableName);
                    if (current == null) {
                        LOG.info("Table {} does not exist, skip modifying", (Object)this.tableName);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    Optional<TableDescriptor> modified = this.modify(env, current);
                    if (modified.isPresent()) {
                        this.modifiedTableDescriptor = modified.get();
                        this.setNextState(MasterProcedureProtos.ModifyTableDescriptorState.MODIFY_TABLE_DESCRIPTOR_UPDATE);
                        return StateMachineProcedure.Flow.HAS_MORE_STATE;
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                case MODIFY_TABLE_DESCRIPTOR_UPDATE: {
                    env.getMasterServices().getTableDescriptors().update(this.modifiedTableDescriptor);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
            }
            throw new UnsupportedOperationException("unhandled state=" + state);
        }
        catch (IOException e) {
            if (this.isRollbackSupported(state)) {
                this.setFailure("master-modify-table-descriptor", e);
            } else {
                LOG.warn("Retriable error trying to modify table descriptor={} (in state={})", new Object[]{this.getTableName(), state, e});
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyTableDescriptorState state) throws IOException, InterruptedException {
        if (state == MasterProcedureProtos.ModifyTableDescriptorState.MODIFY_TABLE_DESCRIPTOR_PREPARE) {
            return;
        }
        throw new UnsupportedOperationException("unhandled state=" + state);
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.ModifyTableDescriptorState state) {
        return state == MasterProcedureProtos.ModifyTableDescriptorState.MODIFY_TABLE_DESCRIPTOR_PREPARE;
    }

    protected MasterProcedureProtos.ModifyTableDescriptorState getState(int stateId) {
        return MasterProcedureProtos.ModifyTableDescriptorState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyTableDescriptorState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyTableDescriptorState getInitialState() {
        return MasterProcedureProtos.ModifyTableDescriptorState.MODIFY_TABLE_DESCRIPTOR_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.ModifyTableDescriptorStateData.Builder builder = MasterProcedureProtos.ModifyTableDescriptorStateData.newBuilder().setTableName(ProtobufUtil.toProtoTableName((TableName)this.tableName));
        if (this.modifiedTableDescriptor != null) {
            builder.setModifiedTableSchema(ProtobufUtil.toTableSchema((TableDescriptor)this.modifiedTableDescriptor));
        }
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.ModifyTableDescriptorStateData data = (MasterProcedureProtos.ModifyTableDescriptorStateData)serializer.deserialize(MasterProcedureProtos.ModifyTableDescriptorStateData.class);
        this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)data.getTableName());
        if (data.hasModifiedTableSchema()) {
            this.modifiedTableDescriptor = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)data.getModifiedTableSchema());
        }
    }
}

