/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.persistence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import org.ehcache.CachePersistenceException;
import org.ehcache.core.spi.service.LocalPersistenceService;
import org.ehcache.impl.config.persistence.DefaultPersistenceConfiguration;
import org.ehcache.impl.persistence.FileUtils;
import org.ehcache.spi.service.MaintainableService;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalPersistenceService
implements LocalPersistenceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalPersistenceService.class);
    private final File rootDirectory;
    private final File lockFile;
    private FileLock lock;
    private RandomAccessFile rw;
    private boolean started;

    public DefaultLocalPersistenceService(DefaultPersistenceConfiguration persistenceConfiguration) {
        if (persistenceConfiguration == null) {
            throw new NullPointerException("DefaultPersistenceConfiguration cannot be null");
        }
        this.rootDirectory = persistenceConfiguration.getRootDirectory();
        this.lockFile = new File(this.rootDirectory, ".lock");
    }

    @Override
    public synchronized void start(ServiceProvider<Service> serviceProvider) {
        this.internalStart();
    }

    @Override
    public synchronized void startForMaintenance(ServiceProvider<? super MaintainableService> serviceProvider, MaintainableService.MaintenanceScope maintenanceScope) {
        this.internalStart();
    }

    private void internalStart() {
        if (!this.started) {
            FileUtils.createLocationIfRequiredAndVerify(this.rootDirectory);
            try {
                this.rw = new RandomAccessFile(this.lockFile, "rw");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                this.lock = this.rw.getChannel().lock();
            }
            catch (Exception e) {
                try {
                    this.rw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException("Couldn't lock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = true;
            LOGGER.debug("RootDirectory Locked");
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            try {
                this.lock.release();
                this.rw.close();
                if (!this.lockFile.delete()) {
                    LOGGER.debug("Lock file was not deleted {}.", (Object)this.lockFile.getPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't unlock rootDir: " + this.rootDirectory.getAbsolutePath(), e);
            }
            this.started = false;
            LOGGER.debug("RootDirectory Unlocked");
        }
    }

    File getLockFile() {
        return this.lockFile;
    }

    @Override
    public LocalPersistenceService.SafeSpaceIdentifier createSafeSpaceIdentifier(String owner, String identifier) {
        FileUtils.validateName(owner);
        SafeSpace ss = this.createSafeSpaceLogical(owner, identifier);
        for (File parent = ss.directory.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!this.rootDirectory.equals(parent)) continue;
            return new DefaultSafeSpaceIdentifier(ss);
        }
        throw new IllegalArgumentException("Attempted to access file outside the persistence path");
    }

    @Override
    public void createSafeSpace(LocalPersistenceService.SafeSpaceIdentifier safeSpaceId) throws CachePersistenceException {
        if (safeSpaceId == null || !(safeSpaceId instanceof DefaultSafeSpaceIdentifier)) {
            throw new AssertionError((Object)"Invalid safe space identifier. Identifier not created");
        }
        SafeSpace ss = ((DefaultSafeSpaceIdentifier)safeSpaceId).safeSpace;
        FileUtils.create(ss.directory.getParentFile());
        FileUtils.create(ss.directory);
    }

    @Override
    public void destroySafeSpace(LocalPersistenceService.SafeSpaceIdentifier safeSpaceId, boolean verbose) {
        if (safeSpaceId == null || !(safeSpaceId instanceof DefaultSafeSpaceIdentifier)) {
            throw new AssertionError((Object)"Invalid safe space identifier. Identifier not created");
        }
        SafeSpace ss = ((DefaultSafeSpaceIdentifier)safeSpaceId).safeSpace;
        this.destroy(ss, verbose);
    }

    @Override
    public void destroyAll(String owner) {
        File ownerDirectory = new File(this.rootDirectory, owner);
        boolean cleared = true;
        if (ownerDirectory.exists() && ownerDirectory.isDirectory()) {
            cleared = false;
            if (FileUtils.recursiveDeleteDirectoryContent(ownerDirectory)) {
                LOGGER.debug("Destroyed all file based persistence contexts owned by {}", (Object)owner);
                cleared = ownerDirectory.delete();
            }
        }
        if (!cleared) {
            LOGGER.warn("Could not delete all file based persistence contexts owned by {}", (Object)owner);
        }
    }

    private void destroy(SafeSpace ss, boolean verbose) {
        if (verbose) {
            LOGGER.debug("Destroying file based persistence context for {}", (Object)ss.identifier);
        }
        if (ss.directory.exists() && !FileUtils.tryRecursiveDelete(ss.directory) && verbose) {
            LOGGER.warn("Could not delete directory for context {}", (Object)ss.identifier);
        }
    }

    private SafeSpace createSafeSpaceLogical(String owner, String identifier) {
        File ownerDirectory = new File(this.rootDirectory, owner);
        File directory = new File(ownerDirectory, FileUtils.safeIdentifier(identifier));
        return new SafeSpace(identifier, directory);
    }

    private static final class DefaultSafeSpaceIdentifier
    implements LocalPersistenceService.SafeSpaceIdentifier {
        private final SafeSpace safeSpace;

        private DefaultSafeSpaceIdentifier(SafeSpace safeSpace) {
            this.safeSpace = safeSpace;
        }

        public String toString() {
            return this.safeSpace.identifier;
        }

        @Override
        public File getRoot() {
            return this.safeSpace.directory;
        }
    }

    private static final class SafeSpace {
        private final String identifier;
        private final File directory;

        private SafeSpace(String identifier, File directory) {
            this.directory = directory;
            this.identifier = identifier;
        }
    }
}

