/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.replication.HBaseReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSinkManager;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={ReplicationTests.class, SmallTests.class})
public class TestReplicationSinkManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSinkManager.class);
    private static final String PEER_CLUSTER_ID = "PEER_CLUSTER_ID";
    private ReplicationSinkManager sinkManager;
    private HBaseReplicationEndpoint replicationEndpoint;

    @Before
    public void setUp() {
        this.replicationEndpoint = new SetServersHBaseReplicationEndpoint();
        this.sinkManager = new ReplicationSinkManager((ClusterConnection)Mockito.mock(ClusterConnection.class), PEER_CLUSTER_ID, this.replicationEndpoint, new Configuration());
    }

    @Test
    public void testChooseSinks() {
        ArrayList serverNames = Lists.newArrayList();
        int totalServers = 20;
        for (int i = 0; i < totalServers; ++i) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        this.replicationEndpoint.setRegionServers((List)serverNames);
        this.sinkManager.chooseSinks();
        int expected = (int)((float)totalServers * 0.5f);
        Assert.assertEquals((long)expected, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testChooseSinks_LessThanRatioAvailable() {
        ArrayList serverNames = Lists.newArrayList((Object[])new ServerName[]{(ServerName)Mockito.mock(ServerName.class), (ServerName)Mockito.mock(ServerName.class)});
        this.replicationEndpoint.setRegionServers((List)serverNames);
        this.sinkManager.chooseSinks();
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testReportBadSink() {
        ServerName serverNameA = (ServerName)Mockito.mock(ServerName.class);
        ServerName serverNameB = (ServerName)Mockito.mock(ServerName.class);
        this.replicationEndpoint.setRegionServers((List)Lists.newArrayList((Object[])new ServerName[]{serverNameA, serverNameB}));
        this.sinkManager.chooseSinks();
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
        ReplicationSinkManager.SinkPeer sinkPeer = new ReplicationSinkManager.SinkPeer(serverNameA, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        this.sinkManager.reportBadSink(sinkPeer);
        Assert.assertEquals((long)1L, (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testReportBadSink_PastThreshold() {
        int i;
        ArrayList serverNames = Lists.newArrayList();
        int totalServers = 30;
        for (int i2 = 0; i2 < totalServers; ++i2) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        this.replicationEndpoint.setRegionServers((List)serverNames);
        this.sinkManager.chooseSinks();
        int expected = (int)((float)totalServers * 0.5f);
        Assert.assertEquals((long)expected, (long)this.sinkManager.getNumSinks());
        ServerName serverName = (ServerName)this.sinkManager.getSinksForTesting().get(0);
        ReplicationSinkManager.SinkPeer sinkPeer = new ReplicationSinkManager.SinkPeer(serverName, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        this.sinkManager.reportSinkSuccess(sinkPeer);
        for (i = 0; i <= 3; ++i) {
            this.sinkManager.reportBadSink(sinkPeer);
        }
        Assert.assertEquals((long)(expected - 1), (long)this.sinkManager.getNumSinks());
        serverName = (ServerName)this.sinkManager.getSinksForTesting().get(0);
        sinkPeer = new ReplicationSinkManager.SinkPeer(serverName, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        for (i = 0; i <= 2; ++i) {
            this.sinkManager.reportBadSink(sinkPeer);
        }
        this.sinkManager.reportSinkSuccess(sinkPeer);
        this.sinkManager.reportBadSink(sinkPeer);
        Assert.assertEquals((long)(expected - 1), (long)this.sinkManager.getNumSinks());
        for (i = 0; i <= 1; ++i) {
            this.sinkManager.reportBadSink(sinkPeer);
        }
        Assert.assertEquals((long)(expected - 1), (long)this.sinkManager.getNumSinks());
        this.sinkManager.reportBadSink(sinkPeer);
        Assert.assertEquals((long)(expected - 2), (long)this.sinkManager.getNumSinks());
    }

    @Test
    public void testReportBadSink_DownToZeroSinks() {
        ArrayList serverNames = Lists.newArrayList();
        int totalServers = 4;
        for (int i = 0; i < totalServers; ++i) {
            serverNames.add(Mockito.mock(ServerName.class));
        }
        this.replicationEndpoint.setRegionServers((List)serverNames);
        this.sinkManager.chooseSinks();
        List sinkList = this.sinkManager.getSinksForTesting();
        int expected = (int)((float)totalServers * 0.5f);
        Assert.assertEquals((long)expected, (long)sinkList.size());
        ServerName serverNameA = (ServerName)sinkList.get(0);
        ServerName serverNameB = (ServerName)sinkList.get(1);
        ReplicationSinkManager.SinkPeer sinkPeerA = new ReplicationSinkManager.SinkPeer(serverNameA, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        ReplicationSinkManager.SinkPeer sinkPeerB = new ReplicationSinkManager.SinkPeer(serverNameB, (AdminProtos.AdminService.BlockingInterface)Mockito.mock(AdminProtos.AdminService.BlockingInterface.class));
        for (int i = 0; i <= 3; ++i) {
            this.sinkManager.reportBadSink(sinkPeerA);
            this.sinkManager.reportBadSink(sinkPeerB);
        }
        expected = (int)((float)(totalServers - 2) * 0.5f);
        Assert.assertEquals((long)expected, (long)this.sinkManager.getNumSinks());
    }

    private static class SetServersHBaseReplicationEndpoint
    extends HBaseReplicationEndpoint {
        List<ServerName> regionServers;

        private SetServersHBaseReplicationEndpoint() {
        }

        public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
            return false;
        }

        public synchronized void setRegionServers(List<ServerName> regionServers) {
            this.regionServers = regionServers;
        }

        public List<ServerName> getRegionServers() {
            return this.regionServers;
        }
    }
}

