/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.FIFOCompactionPolicy;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.TimeOffsetEnvironmentEdge;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestFIFOCompactionPolicy {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFIFOCompactionPolicy.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final TableName tableName = TableName.valueOf((String)this.getClass().getSimpleName());
    private final byte[] family = Bytes.toBytes((String)"f");
    private final byte[] qualifier = Bytes.toBytes((String)"q");
    @Rule
    public ExpectedException error = ExpectedException.none();

    private HStore getStoreWithName(TableName tableName) {
        MiniHBaseCluster cluster = TEST_UTIL.getMiniHBaseCluster();
        List<JVMClusterUtil.RegionServerThread> rsts = cluster.getRegionServerThreads();
        for (int i = 0; i < cluster.getRegionServerThreads().size(); ++i) {
            HRegionServer hrs = rsts.get(i).getRegionServer();
            Iterator iterator = hrs.getRegions(tableName).iterator();
            if (!iterator.hasNext()) continue;
            HRegion region = (HRegion)iterator.next();
            return (HStore)region.getStores().iterator().next();
        }
        return null;
    }

    private HStore prepareData() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setValue(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, FIFOCompactionPolicy.class.getName()).setValue("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setTimeToLive(1).build()).build();
        admin.createTable(desc);
        Table table = TEST_UTIL.getConnection().getTable(this.tableName);
        TimeOffsetEnvironmentEdge edge = (TimeOffsetEnvironmentEdge)EnvironmentEdgeManager.getDelegate();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                byte[] value = new byte[131072];
                Bytes.random((byte[])value);
                table.put(new Put(Bytes.toBytes((int)(i * 10 + j))).addColumn(this.family, this.qualifier, value));
            }
            admin.flush(this.tableName);
            edge.increment(1001L);
        }
        return this.getStoreWithName(this.tableName);
    }

    @BeforeClass
    public static void setEnvironmentEdge() throws Exception {
        TimeOffsetEnvironmentEdge ee = new TimeOffsetEnvironmentEdge();
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)ee);
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt(HStore.BLOCKING_STOREFILES_KEY, 10000);
        conf.setBoolean("hbase.store.delete.expired.storefile", false);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void resetEnvironmentEdge() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testPurgeExpiredFiles() throws Exception {
        final HStore store = this.prepareData();
        Assert.assertEquals((long)10L, (long)store.getStorefilesCount());
        TEST_UTIL.getAdmin().majorCompact(this.tableName);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                return store.getStorefilesCount() == 1;
            }

            public String explainFailure() throws Exception {
                return "The store file count " + store.getStorefilesCount() + " is still greater than 1";
            }
        });
    }

    @Test
    public void testSanityCheckTTL() throws IOException {
        this.error.expect(DoNotRetryIOException.class);
        this.error.expectMessage("Default TTL is not supported");
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "-TTL"));
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setValue(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, FIFOCompactionPolicy.class.getName()).setValue("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])this.family)).build();
        TEST_UTIL.getAdmin().createTable(desc);
    }

    @Test
    public void testSanityCheckMinVersion() throws IOException {
        this.error.expect(DoNotRetryIOException.class);
        this.error.expectMessage("MIN_VERSION > 0 is not supported for FIFO compaction");
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "-MinVersion"));
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setValue(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, FIFOCompactionPolicy.class.getName()).setValue("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setTimeToLive(1).setMinVersions(1).build()).build();
        TEST_UTIL.getAdmin().createTable(desc);
    }

    @Test
    public void testSanityCheckBlockingStoreFiles() throws IOException {
        this.error.expect(DoNotRetryIOException.class);
        this.error.expectMessage("Blocking file count 'hbase.hstore.blockingStoreFiles'");
        this.error.expectMessage("is below recommended minimum of 1000 for column family");
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "-BlockingStoreFiles"));
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setValue(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, FIFOCompactionPolicy.class.getName()).setValue("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName()).setValue(HStore.BLOCKING_STOREFILES_KEY, "10").setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setTimeToLive(1).build()).build();
        TEST_UTIL.getAdmin().createTable(desc);
    }

    @Test
    public void testFIFOCompactionPolicyExpiredEmptyHFiles() throws Exception {
        TableName tableName = TableName.valueOf((String)"testFIFOCompactionPolicyExpiredEmptyHFiles");
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setValue(DefaultStoreEngine.DEFAULT_COMPACTION_POLICY_CLASS_KEY, FIFOCompactionPolicy.class.getName()).setValue("hbase.regionserver.region.split.policy", DisabledRegionSplitPolicy.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])this.family).setTimeToLive(1).build()).build();
        Table table = TEST_UTIL.createTable(desc, (byte[][])null);
        long ts = EnvironmentEdgeManager.currentTime() - 10000L;
        Put put = new Put(Bytes.toBytes((String)"row1")).addColumn(this.family, this.qualifier, ts, Bytes.toBytes((String)"value0"));
        table.put(put);
        TEST_UTIL.getAdmin().flush(tableName);
        put = new Put(Bytes.toBytes((String)"row2")).addColumn(this.family, this.qualifier, ts, Bytes.toBytes((String)"value1"));
        table.put(put);
        int testWaitTimeoutMs = 20000;
        TEST_UTIL.getAdmin().flush(tableName);
        HStore store = (HStore)Preconditions.checkNotNull((Object)this.getStoreWithName(tableName));
        Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
        TEST_UTIL.getAdmin().majorCompact(tableName);
        TEST_UTIL.waitFor(20000L, () -> store.getStorefilesCount() == 1);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        HStoreFile sf = (HStoreFile)Preconditions.checkNotNull(store.getStorefiles().iterator().next());
        Assert.assertEquals((long)0L, (long)sf.getReader().getEntries());
        put = new Put(Bytes.toBytes((String)"row3")).addColumn(this.family, this.qualifier, ts, Bytes.toBytes((String)"value1"));
        table.put(put);
        TEST_UTIL.getAdmin().flush(tableName);
        Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
        TEST_UTIL.getAdmin().majorCompact(tableName);
        TEST_UTIL.waitFor(20000L, () -> store.getStorefilesCount() == 1);
        Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
        sf = (HStoreFile)Preconditions.checkNotNull(store.getStorefiles().iterator().next());
        Assert.assertEquals((long)0L, (long)sf.getReader().getEntries());
    }
}

