/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.SnapshotVerifyProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestSnapshotVerifyProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotVerifyProcedure.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotVerifyProcedure.class);
    private HBaseTestingUtility TEST_UTIL;
    private final TableName tableName = TableName.valueOf((String)"TestRSSnapshotVerifier");
    private final byte[] cf = Bytes.toBytes((String)"cf");
    private final SnapshotDescription snapshot = new SnapshotDescription("test-snapshot", this.tableName, SnapshotType.FLUSH);
    private SnapshotProtos.SnapshotDescription snapshotProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)this.snapshot);

    @Before
    public void setup() throws Exception {
        this.TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = this.TEST_UTIL.getConfiguration();
        conf.setInt("hbase.procedure.remote.dispatcher.delay.msec", 10000);
        conf.setInt("hbase.procedure.remote.dispatcher.max.queue.size", 128);
        this.TEST_UTIL.startMiniCluster(3);
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = this.TEST_UTIL.createTable(this.tableName, this.cf, splitKeys);
        this.TEST_UTIL.loadTable(table, this.cf, false);
        this.TEST_UTIL.getAdmin().flush(this.tableName);
        this.snapshotProto = SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Configuration)conf);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Path)rootDir, (Configuration)conf);
        FileSystem workingDirFs = workingDir.getFileSystem(conf);
        if (!workingDirFs.exists(workingDir)) {
            workingDirFs.mkdirs(workingDir);
        }
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(this.snapshot.getName());
        SnapshotManifest manifest = SnapshotManifest.create((Configuration)conf, (FileSystem)workingDirFs, (Path)workingDir, (SnapshotProtos.SnapshotDescription)this.snapshotProto, (ForeignExceptionSnare)monitor);
        manifest.addTableDescriptor(this.TEST_UTIL.getHBaseCluster().getMaster().getTableDescriptors().get(this.tableName));
        SnapshotDescriptionUtils.writeSnapshotInfo((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Path)workingDir, (FileSystem)workingDirFs);
        this.TEST_UTIL.getHBaseCluster().getRegions(this.tableName).forEach(r -> {
            try {
                r.addRegionToSnapshot(this.snapshotProto, (ForeignExceptionSnare)monitor);
            }
            catch (IOException e) {
                LOG.warn("Failed snapshot region {}", (Object)r.getRegionInfo());
            }
        });
        manifest.consolidate();
    }

    @Test
    public void testSimpleVerify() throws Exception {
        Optional<HRegion> regionOpt = this.TEST_UTIL.getHBaseCluster().getRegions(this.tableName).stream().filter(r -> !r.getStore(this.cf).getStorefiles().isEmpty()).findFirst();
        Assert.assertTrue((boolean)regionOpt.isPresent());
        HRegion region = regionOpt.get();
        SnapshotVerifyProcedure p1 = new SnapshotVerifyProcedure(this.snapshotProto, region.getRegionInfo());
        ProcedureExecutor procExec = this.TEST_UTIL.getHBaseCluster().getMaster().getMasterProcedureExecutor();
        long procId = procExec.submitProcedure((Procedure)p1);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Assert.assertTrue((boolean)p1.isSuccess());
        for (HStoreFile file : region.getStore(this.cf).getStorefiles()) {
            this.TEST_UTIL.getDFSCluster().getFileSystem().delete(file.getPath(), true);
            LOG.info("delete store file {}", (Object)file.getPath());
        }
        SnapshotVerifyProcedure p2 = new SnapshotVerifyProcedure(this.snapshotProto, region.getRegionInfo());
        long newProcId = procExec.submitProcedure((Procedure)p2);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)newProcId);
        Assert.assertTrue((boolean)p2.isSuccess());
    }

    @Test
    public void testRestartMaster() throws Exception {
        RegionInfo region = this.TEST_UTIL.getHBaseCluster().getRegions(this.tableName).get(0).getRegionInfo();
        SnapshotVerifyProcedure svp = new SnapshotVerifyProcedure(this.snapshotProto, region);
        HMaster master = this.TEST_UTIL.getHBaseCluster().getMaster();
        long procId = master.getMasterProcedureExecutor().submitProcedure((Procedure)svp);
        this.TEST_UTIL.waitFor(10000L, () -> svp.getServerName() != null);
        ServerName worker = svp.getServerName();
        int availableWorker = master.getSnapshotManager().getAvailableWorker(worker);
        this.TEST_UTIL.getHBaseCluster().killMaster(master.getServerName());
        this.TEST_UTIL.getHBaseCluster().waitForMasterToStop(master.getServerName(), 30000L);
        this.TEST_UTIL.getHBaseCluster().startMaster();
        this.TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        master = this.TEST_UTIL.getHBaseCluster().getMaster();
        SnapshotVerifyProcedure svp2 = (SnapshotVerifyProcedure)master.getMasterProcedureExecutor().getProcedure(SnapshotVerifyProcedure.class, procId);
        Assert.assertNotNull((Object)svp2);
        Assert.assertFalse((boolean)svp2.isFinished());
        Assert.assertNotNull((Object)svp2.getServerName());
        Assert.assertEquals((Object)worker, (Object)svp.getServerName());
        Assert.assertEquals((long)master.getSnapshotManager().getAvailableWorker(worker).intValue(), (long)availableWorker);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)master.getMasterProcedureExecutor(), (Procedure)svp2);
        Assert.assertEquals((long)master.getSnapshotManager().getAvailableWorker(worker).intValue(), (long)(availableWorker + 1));
    }

    @After
    public void teardown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }
}

