/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.BinaryPrefixComparator;
import org.apache.hadoop.hbase.filter.BitComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.ColumnCountGetFilter;
import org.apache.hadoop.hbase.filter.ColumnPaginationFilter;
import org.apache.hadoop.hbase.filter.ColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.ColumnRangeFilter;
import org.apache.hadoop.hbase.filter.ColumnValueFilter;
import org.apache.hadoop.hbase.filter.DependentColumnFilter;
import org.apache.hadoop.hbase.filter.FamilyFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FilterWrapper;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.FirstKeyValueMatchingQualifiersFilter;
import org.apache.hadoop.hbase.filter.FuzzyRowFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.filter.MultipleColumnPrefixFilter;
import org.apache.hadoop.hbase.filter.NullComparator;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RandomRowFilter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.TimestampsFilter;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.testclassification.FilterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={FilterTests.class, MediumTests.class})
public class TestFilterSerialization {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFilterSerialization.class);
    @Parameterized.Parameter(value=0)
    public boolean allowFastReflectionFallthrough;

    @Parameterized.Parameters(name="{index}: allowFastReflectionFallthrough={0}")
    public static Iterable<Object[]> data() {
        return HBaseCommonTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ProtobufUtil.setAllowFastReflectionFallthrough((boolean)true);
    }

    @Test
    public void testColumnCountGetFilter() throws Exception {
        ColumnCountGetFilter columnCountGetFilter = new ColumnCountGetFilter(1);
        Assert.assertTrue((boolean)columnCountGetFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnCountGetFilter))));
    }

    @Test
    public void testColumnPaginationFilter() throws Exception {
        ColumnPaginationFilter columnPaginationFilter = new ColumnPaginationFilter(1, 7);
        Assert.assertTrue((boolean)columnPaginationFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnPaginationFilter))));
    }

    @Test
    public void testColumnPrefixFilter() throws Exception {
        ColumnPrefixFilter columnPrefixFilter = new ColumnPrefixFilter(Bytes.toBytes((String)""));
        Assert.assertTrue((boolean)columnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnPrefixFilter))));
        columnPrefixFilter = new ColumnPrefixFilter(Bytes.toBytes((String)""));
        Assert.assertTrue((boolean)columnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnPrefixFilter))));
    }

    @Test
    public void testColumnRangeFilter() throws Exception {
        ColumnRangeFilter columnRangeFilter = new ColumnRangeFilter(null, true, null, false);
        Assert.assertTrue((boolean)columnRangeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnRangeFilter))));
        columnRangeFilter = new ColumnRangeFilter(Bytes.toBytes((String)"a"), false, Bytes.toBytes((String)"b"), true);
        Assert.assertTrue((boolean)columnRangeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnRangeFilter))));
    }

    @Test
    public void testDependentColumnFilter() throws Exception {
        DependentColumnFilter dependentColumnFilter = new DependentColumnFilter(null, null);
        Assert.assertTrue((boolean)dependentColumnFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)dependentColumnFilter))));
        dependentColumnFilter = new DependentColumnFilter(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qual"), true, CompareOperator.GREATER_OR_EQUAL, (ByteArrayComparable)new BitComparator(Bytes.toBytes((String)"bitComparator"), BitComparator.BitwiseOp.OR));
        Assert.assertTrue((boolean)dependentColumnFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)dependentColumnFilter))));
    }

    @Test
    public void testFamilyFilter() throws Exception {
        FamilyFilter familyFilter = new FamilyFilter(CompareOperator.EQUAL, (ByteArrayComparable)new BinaryPrefixComparator(Bytes.toBytes((String)"testValueOne")));
        Assert.assertTrue((boolean)familyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)familyFilter))));
    }

    @Test
    public void testFilterList() throws Exception {
        FilterList filterList = new FilterList(new LinkedList());
        Assert.assertTrue((boolean)filterList.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)filterList))));
        LinkedList<Object> list = new LinkedList<Object>();
        list.add(new ColumnCountGetFilter(1));
        list.add(new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("testFilterList")));
        Assert.assertTrue((boolean)filterList.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)filterList))));
    }

    @Test
    public void testFilterWrapper() throws Exception {
        FilterWrapper filterWrapper = new FilterWrapper((Filter)new ColumnRangeFilter(Bytes.toBytes((String)"e"), false, Bytes.toBytes((String)"f"), true));
        Assert.assertTrue((boolean)filterWrapper.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)filterWrapper))));
    }

    @Test
    public void testFirstKeyValueMatchingQualifiersFilter() throws Exception {
        TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        FirstKeyValueMatchingQualifiersFilter firstKeyValueMatchingQualifiersFilter = new FirstKeyValueMatchingQualifiersFilter(set);
        Assert.assertTrue((boolean)firstKeyValueMatchingQualifiersFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)firstKeyValueMatchingQualifiersFilter))));
        set.add(Bytes.toBytes((String)"col0"));
        set.add(Bytes.toBytes((String)"col1"));
        firstKeyValueMatchingQualifiersFilter = new FirstKeyValueMatchingQualifiersFilter(set);
        Assert.assertTrue((boolean)firstKeyValueMatchingQualifiersFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)firstKeyValueMatchingQualifiersFilter))));
    }

    @Test
    public void testFirstKeyOnlyFilter() throws Exception {
        FirstKeyOnlyFilter firstKeyOnlyFilter = new FirstKeyOnlyFilter();
        Assert.assertTrue((boolean)firstKeyOnlyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)firstKeyOnlyFilter))));
    }

    @Test
    public void testFuzzyRowFilter() throws Exception {
        LinkedList<Pair> fuzzyList = new LinkedList<Pair>();
        fuzzyList.add(new Pair((Object)Bytes.toBytes((String)"999"), (Object)new byte[]{0, 0, 1}));
        fuzzyList.add(new Pair((Object)Bytes.toBytes((String)"abcd"), (Object)new byte[]{1, 0, 1, 1}));
        FuzzyRowFilter fuzzyRowFilter = new FuzzyRowFilter(fuzzyList);
        Assert.assertTrue((boolean)fuzzyRowFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)fuzzyRowFilter))));
    }

    @Test
    public void testInclusiveStopFilter() throws Exception {
        InclusiveStopFilter inclusiveStopFilter = new InclusiveStopFilter(null);
        Assert.assertTrue((boolean)inclusiveStopFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)inclusiveStopFilter))));
        inclusiveStopFilter = new InclusiveStopFilter(Bytes.toBytes((String)"inclusiveStopFilter"));
        Assert.assertTrue((boolean)inclusiveStopFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)inclusiveStopFilter))));
    }

    @Test
    public void testKeyOnlyFilter() throws Exception {
        KeyOnlyFilter keyOnlyFilter = new KeyOnlyFilter(true);
        Assert.assertTrue((boolean)keyOnlyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)keyOnlyFilter))));
        keyOnlyFilter = new KeyOnlyFilter();
        Assert.assertTrue((boolean)keyOnlyFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)keyOnlyFilter))));
    }

    @Test
    public void testMultipleColumnPrefixFilter() throws Exception {
        Object prefixes = null;
        MultipleColumnPrefixFilter multipleColumnPrefixFilter = new MultipleColumnPrefixFilter(prefixes);
        Assert.assertTrue((boolean)multipleColumnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)multipleColumnPrefixFilter))));
        prefixes = new byte[2][];
        prefixes[0] = Bytes.toBytes((String)"a");
        prefixes[1] = Bytes.toBytes((String)"");
        multipleColumnPrefixFilter = new MultipleColumnPrefixFilter(prefixes);
        Assert.assertTrue((boolean)multipleColumnPrefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)multipleColumnPrefixFilter))));
    }

    @Test
    public void testPageFilter() throws Exception {
        PageFilter pageFilter = new PageFilter(6L);
        Assert.assertTrue((boolean)pageFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)pageFilter))));
    }

    @Test
    public void testPrefixFilter() throws Exception {
        PrefixFilter prefixFilter = new PrefixFilter(null);
        Assert.assertTrue((boolean)prefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)prefixFilter))));
        prefixFilter = new PrefixFilter(Bytes.toBytes((String)"abc"));
        Assert.assertTrue((boolean)prefixFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)prefixFilter))));
    }

    @Test
    public void testQualifierFilter() throws Exception {
        QualifierFilter qualifierFilter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new NullComparator());
        Assert.assertTrue((boolean)qualifierFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)qualifierFilter))));
    }

    @Test
    public void testRandomRowFilter() throws Exception {
        RandomRowFilter randomRowFilter = new RandomRowFilter(0.1f);
        Assert.assertTrue((boolean)randomRowFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)randomRowFilter))));
    }

    @Test
    public void testRowFilter() throws Exception {
        RowFilter rowFilter = new RowFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("testRowFilter"));
        Assert.assertTrue((boolean)rowFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)rowFilter))));
    }

    @Test
    public void testSingleColumnValueExcludeFilter() throws Exception {
        SingleColumnValueExcludeFilter singleColumnValueExcludeFilter = new SingleColumnValueExcludeFilter(null, null, CompareOperator.GREATER_OR_EQUAL, Bytes.toBytes((String)"value"));
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)singleColumnValueExcludeFilter))));
        singleColumnValueExcludeFilter = new SingleColumnValueExcludeFilter(Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"qual"), CompareOperator.LESS_OR_EQUAL, (ByteArrayComparable)new NullComparator(), false, false);
        Assert.assertTrue((boolean)singleColumnValueExcludeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)singleColumnValueExcludeFilter))));
    }

    @Test
    public void testSingleColumnValueFilter() throws Exception {
        SingleColumnValueFilter singleColumnValueFilter = new SingleColumnValueFilter(null, null, CompareOperator.LESS, Bytes.toBytes((String)"value"));
        Assert.assertTrue((boolean)singleColumnValueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)singleColumnValueFilter))));
        singleColumnValueFilter = new SingleColumnValueFilter(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), CompareOperator.NOT_EQUAL, (ByteArrayComparable)new NullComparator(), true, true);
        Assert.assertTrue((boolean)singleColumnValueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)singleColumnValueFilter))));
    }

    @Test
    public void testSkipFilter() throws Exception {
        SkipFilter skipFilter = new SkipFilter((Filter)new PageFilter(6L));
        Assert.assertTrue((boolean)skipFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)skipFilter))));
    }

    @Test
    public void testTimestampsFilter() throws Exception {
        TimestampsFilter timestampsFilter = new TimestampsFilter(new LinkedList());
        Assert.assertTrue((boolean)timestampsFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)timestampsFilter))));
        LinkedList<Long> list = new LinkedList<Long>();
        list.add(EnvironmentEdgeManager.currentTime());
        list.add(EnvironmentEdgeManager.currentTime());
        timestampsFilter = new TimestampsFilter(list);
        Assert.assertTrue((boolean)timestampsFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)timestampsFilter))));
    }

    @Test
    public void testValueFilter() throws Exception {
        ValueFilter valueFilter = new ValueFilter(CompareOperator.NO_OP, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        Assert.assertTrue((boolean)valueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)valueFilter))));
    }

    @Test
    public void testWhileMatchFilter() throws Exception {
        WhileMatchFilter whileMatchFilter = new WhileMatchFilter((Filter)new ColumnRangeFilter(Bytes.toBytes((String)"c"), false, Bytes.toBytes((String)"d"), true));
        Assert.assertTrue((boolean)whileMatchFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)whileMatchFilter))));
    }

    @Test
    public void testMultiRowRangeFilter() throws Exception {
        ArrayList<MultiRowRangeFilter.RowRange> ranges = new ArrayList<MultiRowRangeFilter.RowRange>();
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)30), true, Bytes.toBytes((int)40), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)10), true, Bytes.toBytes((int)20), false));
        ranges.add(new MultiRowRangeFilter.RowRange(Bytes.toBytes((int)60), true, Bytes.toBytes((int)70), false));
        MultiRowRangeFilter multiRowRangeFilter = new MultiRowRangeFilter(ranges);
        Assert.assertTrue((boolean)multiRowRangeFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)multiRowRangeFilter))));
    }

    @Test
    public void testColumnValueFilter() throws Exception {
        ColumnValueFilter columnValueFilter = new ColumnValueFilter(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), CompareOperator.EQUAL, Bytes.toBytes((String)"value"));
        Assert.assertTrue((boolean)columnValueFilter.areSerializedFieldsEqual(ProtobufUtil.toFilter((FilterProtos.Filter)ProtobufUtil.toFilter((Filter)columnValueFilter))));
    }

    @Test
    public void testCustomFilter() throws Exception {
        PrefixFilter baseFilter = new PrefixFilter("foo".getBytes());
        FilterProtos.Filter filterProto = ProtobufUtil.toFilter((Filter)baseFilter);
        String suffix = "" + System.currentTimeMillis() + this.allowFastReflectionFallthrough;
        String className = "CustomLoadedFilter" + suffix;
        filterProto = filterProto.toBuilder().setName(className).build();
        Configuration conf = HBaseConfiguration.create();
        HBaseTestingUtility testUtil = new HBaseTestingUtility();
        String dataTestDir = testUtil.getDataTestDir().toString();
        ClassLoaderTestHelper.deleteClass((String)className, (String)dataTestDir, (Configuration)conf);
        try {
            Filter filter = ProtobufUtil.toFilter((FilterProtos.Filter)filterProto);
            Assert.fail((String)"expected to fail");
        }
        catch (DoNotRetryIOException filter) {
            // empty catch block
        }
        String code = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/CustomLoadedFilter.java.template"), (Charset)Charset.defaultCharset()).replaceAll("\\$\\{suffix\\}", suffix);
        ClassLoaderTestHelper.buildJar((String)dataTestDir, (String)className, (String)code, (String)ClassLoaderTestHelper.localDirPath((Configuration)conf));
        ProtobufUtil.setAllowFastReflectionFallthrough((boolean)false);
        try {
            ProtobufUtil.toFilter((FilterProtos.Filter)filterProto);
            Assert.fail((String)"expected to fail");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        ProtobufUtil.setAllowFastReflectionFallthrough((boolean)true);
        ProtobufUtil.toFilter((FilterProtos.Filter)filterProto);
    }
}

