/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.crypto.tls;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.crypto.tls.FileKeyStoreLoader;
import org.apache.hadoop.hbase.io.crypto.tls.FileKeyStoreLoaderBuilderProvider;
import org.apache.hadoop.hbase.io.crypto.tls.JKSFileLoader;
import org.apache.hadoop.hbase.io.crypto.tls.KeyStoreFileType;
import org.apache.hadoop.hbase.io.crypto.tls.PEMFileLoader;
import org.apache.hadoop.hbase.io.crypto.tls.PKCS12FileLoader;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestFileKeyStoreLoaderBuilderProvider {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFileKeyStoreLoaderBuilderProvider.class);

    @Test
    public void testGetBuilderForJKSFileType() {
        FileKeyStoreLoader.Builder builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType((KeyStoreFileType)KeyStoreFileType.JKS);
        Assert.assertTrue((boolean)(builder instanceof JKSFileLoader.Builder));
    }

    @Test
    public void testGetBuilderForPEMFileType() {
        FileKeyStoreLoader.Builder builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType((KeyStoreFileType)KeyStoreFileType.PEM);
        Assert.assertTrue((boolean)(builder instanceof PEMFileLoader.Builder));
    }

    @Test
    public void testGetBuilderForPKCS12FileType() {
        FileKeyStoreLoader.Builder builder = FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType((KeyStoreFileType)KeyStoreFileType.PKCS12);
        Assert.assertTrue((boolean)(builder instanceof PKCS12FileLoader.Builder));
    }

    @Test(expected=NullPointerException.class)
    public void testGetBuilderForNullFileType() {
        FileKeyStoreLoaderBuilderProvider.getBuilderForKeyStoreFileType(null);
    }
}

