/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.conf;

import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.conf.ConfigKey;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestConfigKey {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConfigKey.class);

    private void assertThrows(Runnable r) {
        try {
            r.run();
            Assert.fail((String)"validation should have failed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertPasses(Configuration conf, Consumer<Configuration> block) {
        CompoundConfiguration copy = new CompoundConfiguration().add(conf);
        block.accept((Configuration)copy);
        ConfigKey.validate((Configuration)copy);
    }

    private void assertThrows(Configuration conf, Consumer<Configuration> block) {
        CompoundConfiguration copy = new CompoundConfiguration().add(conf);
        block.accept((Configuration)copy);
        this.assertThrows(() -> TestConfigKey.lambda$assertThrows$0((Configuration)copy));
    }

    @Test
    public void testConfigKey() {
        CompoundConfiguration conf = new CompoundConfiguration();
        String intKey = UUID.randomUUID().toString();
        ConfigKey.INT((String)intKey, (Predicate[])new Predicate[0]);
        conf.set(intKey, "1");
        String longKey = UUID.randomUUID().toString();
        ConfigKey.LONG((String)longKey, (Predicate[])new Predicate[0]);
        conf.set(longKey, "1");
        String floatKey = UUID.randomUUID().toString();
        ConfigKey.FLOAT((String)floatKey, (Predicate[])new Predicate[0]);
        conf.set(floatKey, "1.0");
        String doubleKey = UUID.randomUUID().toString();
        ConfigKey.DOUBLE((String)doubleKey, (Predicate[])new Predicate[0]);
        conf.set(doubleKey, "1.0");
        String classKey = UUID.randomUUID().toString();
        ConfigKey.CLASS((String)classKey, Interface.class);
        conf.set(classKey, Class.class.getName());
        String booleanKey = UUID.randomUUID().toString();
        ConfigKey.BOOLEAN((String)booleanKey);
        conf.set(booleanKey, "true");
        ConfigKey.validate((Configuration)conf);
        ConfigKey.INT((String)intKey, (Predicate[])new Predicate[]{i -> i < 0});
        this.assertThrows(() -> TestConfigKey.lambda$testConfigKey$2((Configuration)conf));
        ConfigKey.INT((String)intKey, (Predicate[])new Predicate[]{i -> i > 0, i -> i < 2});
        ConfigKey.validate((Configuration)conf);
        ConfigKey.INT((String)intKey, (Predicate[])new Predicate[0]);
        this.assertPasses((Configuration)conf, copy -> copy.set(intKey, String.valueOf(Integer.MAX_VALUE)));
        this.assertPasses((Configuration)conf, copy -> copy.set(longKey, String.valueOf(Long.MAX_VALUE)));
        this.assertPasses((Configuration)conf, copy -> copy.set(floatKey, String.valueOf(Float.MAX_VALUE)));
        this.assertPasses((Configuration)conf, copy -> copy.set(doubleKey, String.valueOf(Double.MAX_VALUE)));
        this.assertPasses((Configuration)conf, copy -> copy.set(booleanKey, "yeah?"));
        this.assertThrows((Configuration)conf, copy -> copy.set(intKey, "x"));
        this.assertThrows((Configuration)conf, copy -> copy.set(longKey, "92233720368547758070"));
        this.assertThrows((Configuration)conf, copy -> copy.set(longKey, "x"));
        this.assertThrows((Configuration)conf, copy -> copy.set(floatKey, "x"));
        this.assertThrows((Configuration)conf, copy -> copy.set(doubleKey, "x"));
        this.assertThrows((Configuration)conf, copy -> copy.set(classKey, "NoSuchClass"));
        this.assertThrows((Configuration)conf, copy -> copy.set(classKey, this.getClass().getName()));
    }

    private static /* synthetic */ void lambda$testConfigKey$2(Configuration conf) {
        ConfigKey.validate((Configuration)conf);
    }

    private static /* synthetic */ void lambda$assertThrows$0(Configuration copy) {
        ConfigKey.validate((Configuration)copy);
    }

    private class Class
    implements Interface {
        private Class() {
        }
    }

    private static interface Interface {
    }
}

