/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.tool.BulkLoadHFiles;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class BulkLoadHFilesTool
extends LoadIncrementalHFiles
implements BulkLoadHFiles {
    public static final String NAME = "completebulkload";

    public BulkLoadHFilesTool(Configuration conf) {
        super(conf);
    }

    private Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> convert(Map<LoadIncrementalHFiles.LoadQueueItem, ByteBuffer> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> (LoadIncrementalHFiles.LoadQueueItem)e.getKey(), e -> (ByteBuffer)e.getValue()));
    }

    @Override
    public Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> bulkLoad(TableName tableName, Map<byte[], List<Path>> family2Files) throws TableNotFoundException, IOException {
        return this.convert(this.run(family2Files, tableName));
    }

    @Override
    public Map<BulkLoadHFiles.LoadQueueItem, ByteBuffer> bulkLoad(TableName tableName, Path dir) throws TableNotFoundException, IOException {
        return this.convert(this.run(dir, tableName));
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        int ret = ToolRunner.run((Configuration)conf, (Tool)new BulkLoadHFilesTool(conf), (String[])args);
        System.exit(ret);
    }
}

