/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.SlowLogParams;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.namequeues.LogHandlerUtils;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueService;
import org.apache.hadoop.hbase.namequeues.RpcLogDetails;
import org.apache.hadoop.hbase.namequeues.SlowLogPersistentService;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.TooSlowLog;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.collect.EvictingQueue;
import org.apache.hbase.thirdparty.com.google.common.collect.Queues;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogQueueService
implements NamedQueueService {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogQueueService.class);
    private static final String SLOW_LOG_RING_BUFFER_SIZE = "hbase.regionserver.slowlog.ringbuffer.size";
    private final boolean isOnlineLogProviderEnabled;
    private final boolean isSlowLogTableEnabled;
    private final SlowLogPersistentService slowLogPersistentService;
    private final Queue<TooSlowLog.SlowLogPayload> slowLogQueue;
    private final boolean slowLogScanPayloadEnabled;

    public SlowLogQueueService(Configuration conf) {
        this.isOnlineLogProviderEnabled = conf.getBoolean("hbase.regionserver.slowlog.buffer.enabled", false);
        this.slowLogScanPayloadEnabled = conf.getBoolean("hbase.slowlog.scan.payload.enabled", false);
        if (!this.isOnlineLogProviderEnabled) {
            this.isSlowLogTableEnabled = false;
            this.slowLogPersistentService = null;
            this.slowLogQueue = null;
            return;
        }
        int slowLogQueueSize = conf.getInt(SLOW_LOG_RING_BUFFER_SIZE, 256);
        EvictingQueue evictingQueue = EvictingQueue.create(slowLogQueueSize);
        this.slowLogQueue = Queues.synchronizedQueue(evictingQueue);
        this.isSlowLogTableEnabled = conf.getBoolean("hbase.regionserver.slowlog.systable.enabled", false);
        this.slowLogPersistentService = this.isSlowLogTableEnabled ? new SlowLogPersistentService(conf) : null;
    }

    @Override
    public NamedQueuePayload.NamedQueueEvent getEvent() {
        return NamedQueuePayload.NamedQueueEvent.SLOW_LOG;
    }

    @Override
    public void consumeEventFromDisruptor(NamedQueuePayload namedQueuePayload) {
        if (!this.isOnlineLogProviderEnabled) {
            return;
        }
        if (!(namedQueuePayload instanceof RpcLogDetails)) {
            LOG.warn("SlowLogQueueService: NamedQueuePayload is not of type RpcLogDetails.");
            return;
        }
        RpcLogDetails rpcLogDetails = (RpcLogDetails)namedQueuePayload;
        RpcCall rpcCall = rpcLogDetails.getRpcCall();
        String clientAddress = rpcLogDetails.getClientAddress();
        long responseSize = rpcLogDetails.getResponseSize();
        long blockBytesScanned = rpcLogDetails.getBlockBytesScanned();
        long fsReadTime = rpcLogDetails.getFsReadTime();
        String className = rpcLogDetails.getClassName();
        TooSlowLog.SlowLogPayload.Type type = this.getLogType(rpcLogDetails);
        if (type == null) {
            return;
        }
        Descriptors.MethodDescriptor methodDescriptor = rpcCall.getMethod();
        Message param = rpcLogDetails.getParam();
        long receiveTime = rpcCall.getReceiveTime();
        long startTime = rpcCall.getStartTime();
        long endTime = EnvironmentEdgeManager.currentTime();
        int processingTime = (int)(endTime - startTime);
        int qTime = (int)(startTime - receiveTime);
        SlowLogParams slowLogParams = ProtobufUtil.getSlowLogParams(param, this.slowLogScanPayloadEnabled);
        int numGets = 0;
        int numMutations = 0;
        int numServiceCalls = 0;
        if (param instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest multi = (ClientProtos.MultiRequest)param;
            for (ClientProtos.RegionAction regionAction : multi.getRegionActionList()) {
                for (ClientProtos.Action action : regionAction.getActionList()) {
                    if (action.hasMutation()) {
                        ++numMutations;
                    }
                    if (action.hasGet()) {
                        ++numGets;
                    }
                    if (!action.hasServiceCall()) continue;
                    ++numServiceCalls;
                }
            }
        }
        String userName = rpcCall.getRequestUserName().orElse("");
        String methodDescriptorName = methodDescriptor != null ? methodDescriptor.getName() : "";
        TooSlowLog.SlowLogPayload.Builder slowLogPayloadBuilder = TooSlowLog.SlowLogPayload.newBuilder().setCallDetails(methodDescriptorName + "(" + param.getClass().getName() + ")").setClientAddress(clientAddress).setMethodName(methodDescriptorName).setMultiGets(numGets).setMultiMutations(numMutations).setMultiServiceCalls(numServiceCalls).setParam(slowLogParams != null ? slowLogParams.getParams() : "").setProcessingTime(processingTime).setQueueTime(qTime).setRegionName(slowLogParams != null ? slowLogParams.getRegionName() : "").setResponseSize(responseSize).setBlockBytesScanned(blockBytesScanned).setFsReadTime(fsReadTime).setServerClass(className).setStartTime(startTime).setType(type).setUserName(userName).addAllRequestAttribute(SlowLogQueueService.buildNameBytesPairs(rpcLogDetails.getRequestAttributes())).addAllConnectionAttribute(SlowLogQueueService.buildNameBytesPairs(rpcLogDetails.getConnectionAttributes()));
        if (slowLogParams != null && slowLogParams.getScan() != null) {
            slowLogPayloadBuilder.setScan(slowLogParams.getScan());
        }
        TooSlowLog.SlowLogPayload slowLogPayload = slowLogPayloadBuilder.build();
        this.slowLogQueue.add(slowLogPayload);
        if (this.isSlowLogTableEnabled && !slowLogPayload.getRegionName().startsWith("hbase:slowlog")) {
            this.slowLogPersistentService.addToQueueForSysTable(slowLogPayload);
        }
    }

    private static Collection<HBaseProtos.NameBytesPair> buildNameBytesPairs(Map<String, byte[]> attributes) {
        if (attributes == null) {
            return Collections.emptySet();
        }
        return attributes.entrySet().stream().map(attr -> HBaseProtos.NameBytesPair.newBuilder().setName((String)attr.getKey()).setValue(ByteString.copyFrom((byte[])attr.getValue())).build()).collect(Collectors.toSet());
    }

    @Override
    public boolean clearNamedQueue() {
        if (!this.isOnlineLogProviderEnabled) {
            return false;
        }
        LOG.debug("Received request to clean up online slowlog buffer.");
        this.slowLogQueue.clear();
        return true;
    }

    @Override
    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        if (!this.isOnlineLogProviderEnabled) {
            return null;
        }
        AdminProtos.SlowLogResponseRequest slowLogResponseRequest = request.getSlowLogResponseRequest();
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG.equals(slowLogResponseRequest.getLogType()) ? this.getLargeLogPayloads(slowLogResponseRequest) : this.getSlowLogPayloads(slowLogResponseRequest);
        NamedQueueGetResponse response = new NamedQueueGetResponse();
        response.setNamedQueueEvent(0);
        response.setSlowLogPayloads(slowLogPayloads);
        return response;
    }

    private TooSlowLog.SlowLogPayload.Type getLogType(RpcLogDetails rpcCallDetails) {
        boolean isSlowLog = rpcCallDetails.isSlowLog();
        boolean isLargeLog = rpcCallDetails.isLargeLog();
        if (!isSlowLog && !isLargeLog) {
            LOG.error("slowLog and largeLog both are false. Ignoring the event. rpcCallDetails: {}", (Object)rpcCallDetails);
            return null;
        }
        TooSlowLog.SlowLogPayload.Type type = isSlowLog && isLargeLog ? TooSlowLog.SlowLogPayload.Type.ALL : (isSlowLog ? TooSlowLog.SlowLogPayload.Type.SLOW_LOG : TooSlowLog.SlowLogPayload.Type.LARGE_LOG);
        return type;
    }

    @Override
    public void persistAll(Connection connection) {
        if (!this.isOnlineLogProviderEnabled) {
            return;
        }
        if (this.slowLogPersistentService != null) {
            this.slowLogPersistentService.addAllLogsToSysTable(connection);
        }
    }

    private List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        List<TooSlowLog.SlowLogPayload> slowLogPayloadList = Arrays.stream(this.slowLogQueue.toArray(new TooSlowLog.SlowLogPayload[0])).filter(e -> e.getType() == TooSlowLog.SlowLogPayload.Type.ALL || e.getType() == TooSlowLog.SlowLogPayload.Type.SLOW_LOG).collect(Collectors.toList());
        Collections.reverse(slowLogPayloadList);
        return LogHandlerUtils.getFilteredLogs(request, slowLogPayloadList);
    }

    private List<TooSlowLog.SlowLogPayload> getLargeLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        List<TooSlowLog.SlowLogPayload> slowLogPayloadList = Arrays.stream(this.slowLogQueue.toArray(new TooSlowLog.SlowLogPayload[0])).filter(e -> e.getType() == TooSlowLog.SlowLogPayload.Type.ALL || e.getType() == TooSlowLog.SlowLogPayload.Type.LARGE_LOG).collect(Collectors.toList());
        Collections.reverse(slowLogPayloadList);
        return LogHandlerUtils.getFilteredLogs(request, slowLogPayloadList);
    }
}

