/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.record.compiler;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.Charsets;
import org.apache.hadoop.hbase.shaded.org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.hadoop.record.compiler.CodeGenerator;
import org.apache.hadoop.record.compiler.JFile;
import org.apache.hadoop.record.compiler.JRecord;
import org.apache.hadoop.util.StringUtils;

class CppGenerator
extends CodeGenerator {
    CppGenerator() {
    }

    @Override
    void genCode(String name, ArrayList<JFile> ilist, ArrayList<JRecord> rlist, String destDir, ArrayList<String> options) throws IOException {
        name = new File(destDir, new File(name).getName()).getAbsolutePath();
        try (FileWriterWithEncoding cc = new FileWriterWithEncoding(name + ".cc", Charsets.UTF_8);
             FileWriterWithEncoding hh = new FileWriterWithEncoding(name + ".hh", Charsets.UTF_8);){
            String fileName = new File(name).getName();
            ((Writer)hh).write("#ifndef __" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
            ((Writer)hh).write("#define __" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
            ((Writer)hh).write("#include \"recordio.hh\"\n");
            ((Writer)hh).write("#include \"recordTypeInfo.hh\"\n");
            Iterator<Object> iter = ilist.iterator();
            while (iter.hasNext()) {
                ((Writer)hh).write("#include \"" + iter.next().getName() + ".hh\"\n");
            }
            ((Writer)cc).write("#include \"" + fileName + ".hh\"\n");
            ((Writer)cc).write("#include \"utils.hh\"\n");
            iter = rlist.iterator();
            while (iter.hasNext()) {
                ((JRecord)iter.next()).genCppCode(hh, cc, options);
            }
            ((Writer)hh).write("#endif //" + StringUtils.toUpperCase(fileName).replace('.', '_') + "__\n");
        }
    }
}

