/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.util.Progressable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class FSDataOutputStreamBuilder<S extends FSDataOutputStream, B extends FSDataOutputStreamBuilder<S, B>> {
    private final FileSystem fs;
    private final Path path;
    private FsPermission permission = null;
    private int bufferSize;
    private short replication;
    private long blockSize;
    private boolean recursive = false;
    private final EnumSet<CreateFlag> flags = EnumSet.noneOf(CreateFlag.class);
    private Progressable progress = null;
    private Options.ChecksumOpt checksumOpt = null;

    protected abstract B getThisBuilder();

    protected FSDataOutputStreamBuilder(@Nonnull FileSystem fileSystem, @Nonnull Path p) {
        Preconditions.checkNotNull(fileSystem);
        Preconditions.checkNotNull(p);
        this.fs = fileSystem;
        this.path = p;
        this.bufferSize = this.fs.getConf().getInt("io.file.buffer.size", 4096);
        this.replication = this.fs.getDefaultReplication(this.path);
        this.blockSize = this.fs.getDefaultBlockSize(p);
    }

    protected FileSystem getFS() {
        return this.fs;
    }

    protected Path getPath() {
        return this.path;
    }

    protected FsPermission getPermission() {
        if (this.permission == null) {
            this.permission = FsPermission.getFileDefault();
        }
        return this.permission;
    }

    public B permission(@Nonnull FsPermission perm) {
        Preconditions.checkNotNull(perm);
        this.permission = perm;
        return this.getThisBuilder();
    }

    protected int getBufferSize() {
        return this.bufferSize;
    }

    public B bufferSize(int bufSize) {
        this.bufferSize = bufSize;
        return this.getThisBuilder();
    }

    protected short getReplication() {
        return this.replication;
    }

    public B replication(short replica) {
        this.replication = replica;
        return this.getThisBuilder();
    }

    protected long getBlockSize() {
        return this.blockSize;
    }

    public B blockSize(long blkSize) {
        this.blockSize = blkSize;
        return this.getThisBuilder();
    }

    protected boolean isRecursive() {
        return this.recursive;
    }

    public B recursive() {
        this.recursive = true;
        return this.getThisBuilder();
    }

    protected Progressable getProgress() {
        return this.progress;
    }

    public B progress(@Nonnull Progressable prog) {
        Preconditions.checkNotNull(prog);
        this.progress = prog;
        return this.getThisBuilder();
    }

    protected EnumSet<CreateFlag> getFlags() {
        return this.flags;
    }

    public B create() {
        this.flags.add(CreateFlag.CREATE);
        return this.getThisBuilder();
    }

    public B overwrite(boolean overwrite) {
        if (overwrite) {
            this.flags.add(CreateFlag.OVERWRITE);
        } else {
            this.flags.remove((Object)CreateFlag.OVERWRITE);
        }
        return this.getThisBuilder();
    }

    public B append() {
        this.flags.add(CreateFlag.APPEND);
        return this.getThisBuilder();
    }

    protected Options.ChecksumOpt getChecksumOpt() {
        return this.checksumOpt;
    }

    public B checksumOpt(@Nonnull Options.ChecksumOpt chksumOpt) {
        Preconditions.checkNotNull(chksumOpt);
        this.checksumOpt = chksumOpt;
        return this.getThisBuilder();
    }

    public abstract S build() throws IOException;
}

