/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.yarn.server.router.webapp.AppsBlock;
import org.apache.hadoop.yarn.server.router.webapp.RouterView;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;

class AppsPage
extends RouterView {
    AppsPage() {
    }

    @Override
    protected void preHead(Hamlet.HTML<HtmlPage.__> html) {
        this.commonPreHead(html);
        this.set("ui.dataTables.id", "apps");
        this.set(JQueryUI.initID((String)"ui.dataTables", (String)"apps"), this.appsTableInit());
        this.setTableStyles(html, "apps", new String[]{".queue {width:6em}", ".ui {width:8em}"});
        String subClusterName = this.$("app.subcluster");
        String reqState = this.$("app.state");
        if (StringUtils.isBlank((CharSequence)subClusterName)) {
            subClusterName = "Federation ";
        }
        reqState = StringUtils.isBlank((CharSequence)reqState) ? "All" : reqState;
        this.setTitle(StringHelper.sjoin((Object[])new Object[]{subClusterName, reqState, "Applications"}));
    }

    private String appsTableInit() {
        return JQueryUI.tableInit().append(", 'aaData': appsTableData").append(", bDeferRender: true").append(", bProcessing: true").append("\n, aoColumnDefs: ").append(this.getAppsTableColumnDefs()).append(", aaSorting: [[0, 'desc']]}").toString();
    }

    protected String getAppsTableColumnDefs() {
        StringBuilder sb = new StringBuilder();
        return sb.append("[\n").append("{'sType':'string', 'aTargets': [0]").append(", 'mRender': parseHadoopID }").append("\n, {'sType':'numeric', 'aTargets': [6, 7]").append(", 'mRender': renderHadoopDate }").append("\n, {'sType':'numeric', bSearchable:false, 'aTargets': [10]").append(", 'mRender': parseHadoopProgress }]").toString();
    }

    @Override
    protected Class<? extends SubView> content() {
        return AppsBlock.class;
    }
}

