/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.clientrm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceProfilesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAllResourceTypeInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetAttributesToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToAttributesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetResourceProfileResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationListResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.resource.Resources;

public final class RouterYarnClientUtils {
    private static final String PARTIAL_REPORT = "Partial Report ";

    private RouterYarnClientUtils() {
    }

    public static GetClusterMetricsResponse merge(Collection<GetClusterMetricsResponse> responses) {
        YarnClusterMetrics tmp = YarnClusterMetrics.newInstance((int)0);
        for (GetClusterMetricsResponse response : responses) {
            YarnClusterMetrics metrics = response.getClusterMetrics();
            tmp.setNumNodeManagers(tmp.getNumNodeManagers() + metrics.getNumNodeManagers());
            tmp.setNumActiveNodeManagers(tmp.getNumActiveNodeManagers() + metrics.getNumActiveNodeManagers());
            tmp.setNumDecommissioningNodeManagers(tmp.getNumDecommissioningNodeManagers() + metrics.getNumDecommissioningNodeManagers());
            tmp.setNumDecommissionedNodeManagers(tmp.getNumDecommissionedNodeManagers() + metrics.getNumDecommissionedNodeManagers());
            tmp.setNumLostNodeManagers(tmp.getNumLostNodeManagers() + metrics.getNumLostNodeManagers());
            tmp.setNumRebootedNodeManagers(tmp.getNumRebootedNodeManagers() + metrics.getNumRebootedNodeManagers());
            tmp.setNumUnhealthyNodeManagers(tmp.getNumUnhealthyNodeManagers() + metrics.getNumUnhealthyNodeManagers());
            tmp.setNumShutdownNodeManagers(tmp.getNumShutdownNodeManagers() + metrics.getNumShutdownNodeManagers());
        }
        return GetClusterMetricsResponse.newInstance((YarnClusterMetrics)tmp);
    }

    public static GetApplicationsResponse mergeApplications(Collection<GetApplicationsResponse> responses, boolean returnPartialResult) {
        HashMap<ApplicationId, ApplicationReport> federationAM = new HashMap<ApplicationId, ApplicationReport>();
        HashMap<ApplicationId, ApplicationReport> federationUAMSum = new HashMap<ApplicationId, ApplicationReport>();
        for (GetApplicationsResponse appResponse : responses) {
            for (ApplicationReport appReport : appResponse.getApplicationList()) {
                ApplicationId appId = appReport.getApplicationId();
                if (!appReport.isUnmanagedApp()) {
                    federationAM.put(appId, appReport);
                    if (!federationUAMSum.containsKey(appId)) continue;
                    RouterYarnClientUtils.mergeAMWithUAM(appReport, (ApplicationReport)federationUAMSum.get(appId));
                    federationUAMSum.remove(appId);
                    continue;
                }
                if (federationAM.containsKey(appId)) {
                    RouterYarnClientUtils.mergeAMWithUAM((ApplicationReport)federationAM.get(appId), appReport);
                    continue;
                }
                if (federationUAMSum.containsKey(appId)) {
                    ApplicationReport mergedUAMReport = RouterYarnClientUtils.mergeUAMWithUAM((ApplicationReport)federationUAMSum.get(appId), appReport);
                    federationUAMSum.put(appId, mergedUAMReport);
                    continue;
                }
                federationUAMSum.put(appId, appReport);
            }
        }
        for (ApplicationReport appReport : federationUAMSum.values()) {
            if (!RouterYarnClientUtils.mergeUamToReport(appReport.getName(), returnPartialResult)) continue;
            federationAM.put(appReport.getApplicationId(), appReport);
        }
        return GetApplicationsResponse.newInstance(federationAM.values());
    }

    private static ApplicationReport mergeUAMWithUAM(ApplicationReport uam1, ApplicationReport uam2) {
        uam1.setName(PARTIAL_REPORT + uam1.getApplicationId());
        RouterYarnClientUtils.mergeAMWithUAM(uam1, uam2);
        return uam1;
    }

    private static void mergeAMWithUAM(ApplicationReport am, ApplicationReport uam) {
        ApplicationResourceUsageReport amResourceReport = am.getApplicationResourceUsageReport();
        ApplicationResourceUsageReport uamResourceReport = uam.getApplicationResourceUsageReport();
        if (amResourceReport == null) {
            am.setApplicationResourceUsageReport(uamResourceReport);
        } else if (uamResourceReport != null) {
            amResourceReport.setNumUsedContainers(amResourceReport.getNumUsedContainers() + uamResourceReport.getNumUsedContainers());
            amResourceReport.setNumReservedContainers(amResourceReport.getNumReservedContainers() + uamResourceReport.getNumReservedContainers());
            amResourceReport.setUsedResources(Resources.add((Resource)amResourceReport.getUsedResources(), (Resource)uamResourceReport.getUsedResources()));
            amResourceReport.setReservedResources(Resources.add((Resource)amResourceReport.getReservedResources(), (Resource)uamResourceReport.getReservedResources()));
            amResourceReport.setNeededResources(Resources.add((Resource)amResourceReport.getNeededResources(), (Resource)uamResourceReport.getNeededResources()));
            amResourceReport.setMemorySeconds(amResourceReport.getMemorySeconds() + uamResourceReport.getMemorySeconds());
            amResourceReport.setVcoreSeconds(amResourceReport.getVcoreSeconds() + uamResourceReport.getVcoreSeconds());
            amResourceReport.setQueueUsagePercentage(amResourceReport.getQueueUsagePercentage() + uamResourceReport.getQueueUsagePercentage());
            amResourceReport.setClusterUsagePercentage(amResourceReport.getClusterUsagePercentage() + uamResourceReport.getClusterUsagePercentage());
            am.setApplicationResourceUsageReport(amResourceReport);
        }
    }

    private static boolean mergeUamToReport(String appName, boolean returnPartialResult) {
        if (returnPartialResult) {
            return true;
        }
        if (appName == null) {
            return false;
        }
        return !appName.startsWith("UnmanagedAM") && !appName.startsWith(PARTIAL_REPORT);
    }

    public static GetClusterNodesResponse mergeClusterNodesResponse(Collection<GetClusterNodesResponse> responses) {
        GetClusterNodesResponse clusterNodesResponse = (GetClusterNodesResponse)Records.newRecord(GetClusterNodesResponse.class);
        ArrayList nodeReports = new ArrayList();
        for (GetClusterNodesResponse response : responses) {
            if (response == null || response.getNodeReports() == null) continue;
            nodeReports.addAll(response.getNodeReports());
        }
        clusterNodesResponse.setNodeReports(nodeReports);
        return clusterNodesResponse;
    }

    public static GetNodesToLabelsResponse mergeNodesToLabelsResponse(Collection<GetNodesToLabelsResponse> responses) {
        GetNodesToLabelsResponse nodesToLabelsResponse = (GetNodesToLabelsResponse)Records.newRecord(GetNodesToLabelsResponse.class);
        HashMap nodesToLabelMap = new HashMap();
        for (GetNodesToLabelsResponse response : responses) {
            if (response == null || response.getNodeToLabels() == null) continue;
            nodesToLabelMap.putAll(response.getNodeToLabels());
        }
        nodesToLabelsResponse.setNodeToLabels(nodesToLabelMap);
        return nodesToLabelsResponse;
    }

    public static GetLabelsToNodesResponse mergeLabelsToNodes(Collection<GetLabelsToNodesResponse> responses) {
        GetLabelsToNodesResponse labelsToNodesResponse = (GetLabelsToNodesResponse)Records.newRecord(GetLabelsToNodesResponse.class);
        HashMap<String, Set> labelsToNodesMap = new HashMap<String, Set>();
        for (GetLabelsToNodesResponse response : responses) {
            if (response == null || response.getLabelsToNodes() == null) continue;
            Map clusterLabelsToNodesMap = response.getLabelsToNodes();
            for (Map.Entry entry : clusterLabelsToNodesMap.entrySet()) {
                String label = (String)entry.getKey();
                Set clusterNodes = (Set)entry.getValue();
                if (labelsToNodesMap.containsKey(label)) {
                    Set allNodes = (Set)labelsToNodesMap.get(label);
                    allNodes.addAll(clusterNodes);
                    continue;
                }
                labelsToNodesMap.put(label, clusterNodes);
            }
        }
        labelsToNodesResponse.setLabelsToNodes(labelsToNodesMap);
        return labelsToNodesResponse;
    }

    public static GetClusterNodeLabelsResponse mergeClusterNodeLabelsResponse(Collection<GetClusterNodeLabelsResponse> responses) {
        GetClusterNodeLabelsResponse nodeLabelsResponse = (GetClusterNodeLabelsResponse)Records.newRecord(GetClusterNodeLabelsResponse.class);
        HashSet nodeLabelsList = new HashSet();
        for (GetClusterNodeLabelsResponse response : responses) {
            if (response == null || response.getNodeLabelList() == null) continue;
            nodeLabelsList.addAll(response.getNodeLabelList());
        }
        nodeLabelsResponse.setNodeLabelList(new ArrayList(nodeLabelsList));
        return nodeLabelsResponse;
    }

    public static GetQueueUserAclsInfoResponse mergeQueueUserAcls(Collection<GetQueueUserAclsInfoResponse> responses) {
        GetQueueUserAclsInfoResponse aclsInfoResponse = (GetQueueUserAclsInfoResponse)Records.newRecord(GetQueueUserAclsInfoResponse.class);
        HashSet queueUserACLInfos = new HashSet();
        for (GetQueueUserAclsInfoResponse response : responses) {
            if (response == null || response.getUserAclsInfoList() == null) continue;
            queueUserACLInfos.addAll(response.getUserAclsInfoList());
        }
        aclsInfoResponse.setUserAclsInfoList(new ArrayList(queueUserACLInfos));
        return aclsInfoResponse;
    }

    public static ReservationListResponse mergeReservationsList(Collection<ReservationListResponse> responses) {
        ReservationListResponse reservationListResponse = (ReservationListResponse)Records.newRecord(ReservationListResponse.class);
        ArrayList reservationAllocationStates = new ArrayList();
        for (ReservationListResponse response : responses) {
            if (response == null || response.getReservationAllocationState() == null) continue;
            reservationAllocationStates.addAll(response.getReservationAllocationState());
        }
        reservationListResponse.setReservationAllocationState(reservationAllocationStates);
        return reservationListResponse;
    }

    public static GetAllResourceTypeInfoResponse mergeResourceTypes(Collection<GetAllResourceTypeInfoResponse> responses) {
        GetAllResourceTypeInfoResponse resourceTypeInfoResponse = (GetAllResourceTypeInfoResponse)Records.newRecord(GetAllResourceTypeInfoResponse.class);
        HashSet resourceTypeInfoSet = new HashSet();
        for (GetAllResourceTypeInfoResponse response : responses) {
            if (response == null || response.getResourceTypeInfo() == null) continue;
            resourceTypeInfoSet.addAll(response.getResourceTypeInfo());
        }
        resourceTypeInfoResponse.setResourceTypeInfo(new ArrayList(resourceTypeInfoSet));
        return resourceTypeInfoResponse;
    }

    public static GetQueueInfoResponse mergeQueues(Collection<GetQueueInfoResponse> responses) {
        GetQueueInfoResponse queueResponse = (GetQueueInfoResponse)Records.newRecord(GetQueueInfoResponse.class);
        QueueInfo queueInfo = null;
        for (GetQueueInfoResponse response : responses) {
            if (response == null || response.getQueueInfo() == null) continue;
            if (queueInfo == null) {
                queueInfo = response.getQueueInfo();
                continue;
            }
            queueInfo.setCapacity(queueInfo.getCapacity() + response.getQueueInfo().getCapacity());
            queueInfo.setMaximumCapacity(queueInfo.getMaximumCapacity() + response.getQueueInfo().getMaximumCapacity());
            queueInfo.setCurrentCapacity(queueInfo.getCurrentCapacity() + response.getQueueInfo().getCurrentCapacity());
            ArrayList childQueues = new ArrayList(queueInfo.getChildQueues());
            childQueues.addAll(response.getQueueInfo().getChildQueues());
            queueInfo.setChildQueues(childQueues);
            ArrayList applicationReports = new ArrayList(queueInfo.getApplications());
            applicationReports.addAll(response.getQueueInfo().getApplications());
            queueInfo.setApplications(applicationReports);
            HashSet accessibleNodeLabels = new HashSet();
            if (queueInfo.getAccessibleNodeLabels() != null) {
                accessibleNodeLabels.addAll(queueInfo.getAccessibleNodeLabels());
            }
            queueInfo.setMinResourceVCore(queueInfo.getMinResourceVCore() + response.getQueueInfo().getMinResourceVCore());
            queueInfo.setMinResourceMemory(queueInfo.getMinResourceMemory() + response.getQueueInfo().getMinResourceMemory());
            queueInfo.setMinResourceVCore(queueInfo.getMaxResourceVCore() + response.getQueueInfo().getMaxResourceVCore());
            queueInfo.setMinResourceMemory(queueInfo.getMaxResourceMemory() + response.getQueueInfo().getMaxResourceMemory());
            queueInfo.setReservedResourceVCore(queueInfo.getReservedResourceVCore() + response.getQueueInfo().getMaxResourceVCore());
            queueInfo.setReservedResourceMemory(queueInfo.getReservedResourceMemory() + response.getQueueInfo().getMaxResourceMemory());
            queueInfo.setMaxRunningApp(queueInfo.getMaxRunningApp() + response.getQueueInfo().getMaxRunningApp());
            queueInfo.setSteadyFairShareVCore(queueInfo.getSteadyFairShareVCore() + response.getQueueInfo().getSteadyFairShareVCore());
            queueInfo.setSteadyFairShareMemory(queueInfo.getSteadyFairShareMemory() + response.getQueueInfo().getSteadyFairShareMemory());
            queueInfo.setWeight(queueInfo.getWeight() + response.getQueueInfo().getWeight());
            if (response.getQueueInfo() != null) {
                accessibleNodeLabels.addAll(response.getQueueInfo().getAccessibleNodeLabels());
            }
            queueInfo.setAccessibleNodeLabels(accessibleNodeLabels);
        }
        queueResponse.setQueueInfo(queueInfo);
        return queueResponse;
    }

    public static GetAllResourceProfilesResponse mergeClusterResourceProfilesResponse(Collection<GetAllResourceProfilesResponse> responses) {
        GetAllResourceProfilesResponse profilesResponse = (GetAllResourceProfilesResponse)Records.newRecord(GetAllResourceProfilesResponse.class);
        HashMap<String, Resource> profilesMap = new HashMap<String, Resource>();
        for (GetAllResourceProfilesResponse response : responses) {
            if (response == null || response.getResourceProfiles() == null) continue;
            for (Map.Entry entry : response.getResourceProfiles().entrySet()) {
                String key = (String)entry.getKey();
                Resource r1 = profilesMap.getOrDefault(key, null);
                Resource r2 = (Resource)entry.getValue();
                Resource rAdd = r1 == null ? r2 : Resources.add((Resource)r1, (Resource)r2);
                profilesMap.put(key, rAdd);
            }
        }
        profilesResponse.setResourceProfiles(profilesMap);
        return profilesResponse;
    }

    public static GetResourceProfileResponse mergeClusterResourceProfileResponse(Collection<GetResourceProfileResponse> responses) {
        GetResourceProfileResponse profileResponse = (GetResourceProfileResponse)Records.newRecord(GetResourceProfileResponse.class);
        Resource resource = Resource.newInstance((int)0, (int)0);
        for (GetResourceProfileResponse response : responses) {
            if (response == null || response.getResource() == null) continue;
            Resource responseResource = response.getResource();
            resource = Resources.add((Resource)resource, (Resource)responseResource);
        }
        profileResponse.setResource(resource);
        return profileResponse;
    }

    public static GetAttributesToNodesResponse mergeAttributesToNodesResponse(Collection<GetAttributesToNodesResponse> responses) {
        HashMap nodeAttributeMap = new HashMap();
        for (GetAttributesToNodesResponse response : responses) {
            if (response == null || response.getAttributesToNodes() == null) continue;
            nodeAttributeMap.putAll(response.getAttributesToNodes());
        }
        return GetAttributesToNodesResponse.newInstance(nodeAttributeMap);
    }

    public static GetClusterNodeAttributesResponse mergeClusterNodeAttributesResponse(Collection<GetClusterNodeAttributesResponse> responses) {
        HashSet nodeAttributeInfo = new HashSet();
        for (GetClusterNodeAttributesResponse response : responses) {
            if (response == null || response.getNodeAttributes() == null) continue;
            nodeAttributeInfo.addAll(response.getNodeAttributes());
        }
        return GetClusterNodeAttributesResponse.newInstance(nodeAttributeInfo);
    }

    public static GetNodesToAttributesResponse mergeNodesToAttributesResponse(Collection<GetNodesToAttributesResponse> responses) {
        HashMap attributesMap = new HashMap();
        for (GetNodesToAttributesResponse response : responses) {
            if (response == null || response.getNodeToAttributes() == null) continue;
            attributesMap.putAll(response.getNodeToAttributes());
        }
        return GetNodesToAttributesResponse.newInstance(attributesMap);
    }
}

