/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.TimelineDocument;
import org.apache.hadoop.yarn.server.timelineservice.documentstore.collection.document.flowactivity.FlowActivitySubDoc;

public class FlowActivityDocument
implements TimelineDocument<FlowActivityDocument> {
    private String id;
    private final String type = TimelineEntityType.YARN_FLOW_ACTIVITY.toString();
    private Set<FlowActivitySubDoc> flowActivities = new HashSet<FlowActivitySubDoc>();
    private long dayTimestamp;
    private String user;
    private String flowName;

    public FlowActivityDocument() {
    }

    public FlowActivityDocument(String flowName, String flowVersion, long flowRunId) {
        this.flowActivities.add(new FlowActivitySubDoc(flowName, flowVersion, flowRunId));
    }

    @Override
    public void merge(FlowActivityDocument flowActivityDocument) {
        if (flowActivityDocument.getDayTimestamp() > 0L) {
            this.dayTimestamp = flowActivityDocument.getDayTimestamp();
        }
        this.flowName = flowActivityDocument.getFlowName();
        this.user = flowActivityDocument.getUser();
        this.id = flowActivityDocument.getId();
        this.flowActivities.addAll(flowActivityDocument.getFlowActivities());
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void addFlowActivity(String flowActivityName, String flowVersion, long flowRunId) {
        this.flowActivities.add(new FlowActivitySubDoc(flowActivityName, flowVersion, flowRunId));
    }

    public Set<FlowActivitySubDoc> getFlowActivities() {
        return this.flowActivities;
    }

    public void setFlowActivities(Set<FlowActivitySubDoc> flowActivities) {
        this.flowActivities = flowActivities;
    }

    @Override
    public long getCreatedTime() {
        return TimeUnit.SECONDS.toMillis(this.dayTimestamp);
    }

    @Override
    public void setCreatedTime(long time) {
    }

    public long getDayTimestamp() {
        return this.dayTimestamp;
    }

    public void setDayTimestamp(long dayTimestamp) {
        this.dayTimestamp = dayTimestamp;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public void setFlowName(String flowName) {
        this.flowName = flowName;
    }
}

