/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter;

import java.util.List;
import org.apache.hadoop.shaded.com.sun.jersey.api.ParamException;
import org.apache.hadoop.shaded.com.sun.jersey.api.core.HttpContext;
import org.apache.hadoop.shaded.com.sun.jersey.api.model.Parameter;
import org.apache.hadoop.shaded.com.sun.jersey.core.spi.component.ComponentContext;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.inject.AbstractHttpContextInjectable;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.BaseParamInjectableProvider;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.ExtractorContainerException;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractor;
import org.apache.hadoop.shaded.com.sun.jersey.server.impl.model.parameter.multivalued.MultivaluedParameterExtractorProvider;
import org.apache.hadoop.shaded.com.sun.jersey.spi.inject.Injectable;
import org.apache.hadoop.shaded.javax.ws.rs.MatrixParam;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.javax.ws.rs.core.PathSegment;

public final class MatrixParamInjectableProvider
extends BaseParamInjectableProvider<MatrixParam> {
    public MatrixParamInjectableProvider(MultivaluedParameterExtractorProvider w) {
        super(w);
    }

    public Injectable getInjectable(ComponentContext ic, MatrixParam a, Parameter c) {
        String parameterName = c.getSourceName();
        if (parameterName == null || parameterName.length() == 0) {
            return null;
        }
        MultivaluedParameterExtractor e = this.get(c);
        if (e == null) {
            return null;
        }
        return new MatrixParamInjectable(e, !c.isEncoded());
    }

    private static final class MatrixParamInjectable
    extends AbstractHttpContextInjectable<Object> {
        private final MultivaluedParameterExtractor extractor;
        private final boolean decode;

        MatrixParamInjectable(MultivaluedParameterExtractor extractor, boolean decode) {
            this.extractor = extractor;
            this.decode = decode;
        }

        @Override
        public Object getValue(HttpContext context) {
            List l = context.getUriInfo().getPathSegments(this.decode);
            PathSegment p = (PathSegment)l.get(l.size() - 1);
            try {
                return this.extractor.extract((MultivaluedMap<String, String>)p.getMatrixParameters());
            }
            catch (ExtractorContainerException e) {
                throw new ParamException.MatrixParamException(e.getCause(), this.extractor.getName(), this.extractor.getDefaultStringValue());
            }
        }
    }
}

