/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.google.inject.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.collect.ImmutableSet;
import org.apache.hadoop.shaded.com.google.common.collect.Iterables;
import org.apache.hadoop.shaded.com.google.inject.Binder;
import org.apache.hadoop.shaded.com.google.inject.Binding;
import org.apache.hadoop.shaded.com.google.inject.Injector;
import org.apache.hadoop.shaded.com.google.inject.Key;
import org.apache.hadoop.shaded.com.google.inject.Module;
import org.apache.hadoop.shaded.com.google.inject.Provider;
import org.apache.hadoop.shaded.com.google.inject.TypeLiteral;
import org.apache.hadoop.shaded.com.google.inject.binder.LinkedBindingBuilder;
import org.apache.hadoop.shaded.com.google.inject.internal.Annotations;
import org.apache.hadoop.shaded.com.google.inject.internal.BindingImpl;
import org.apache.hadoop.shaded.com.google.inject.internal.Errors;
import org.apache.hadoop.shaded.com.google.inject.internal.ErrorsException;
import org.apache.hadoop.shaded.com.google.inject.internal.InjectorImpl;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalContext;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalFactory;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalProviderInstanceBindingImpl;
import org.apache.hadoop.shaded.com.google.inject.internal.InternalProvisionException;
import org.apache.hadoop.shaded.com.google.inject.multibindings.MultibindingsTargetVisitor;
import org.apache.hadoop.shaded.com.google.inject.multibindings.OptionalBinderBinding;
import org.apache.hadoop.shaded.com.google.inject.spi.BindingTargetVisitor;
import org.apache.hadoop.shaded.com.google.inject.spi.Dependency;
import org.apache.hadoop.shaded.com.google.inject.spi.Element;
import org.apache.hadoop.shaded.com.google.inject.spi.ProviderInstanceBinding;
import org.apache.hadoop.shaded.com.google.inject.spi.ProviderWithExtensionVisitor;
import org.apache.hadoop.shaded.com.google.inject.util.Types;
import org.apache.hadoop.shaded.javax.inject.Qualifier;

public final class RealOptionalBinder<T>
implements Module {
    private final BindingSelection<T> bindingSelection;
    private final Binder binder;

    public static <T> RealOptionalBinder<T> newRealOptionalBinder(Binder binder, Key<T> type) {
        binder = binder.skipSources(RealOptionalBinder.class);
        RealOptionalBinder<T> optionalBinder = new RealOptionalBinder<T>(binder, type);
        binder.install(optionalBinder);
        return optionalBinder;
    }

    static <T> TypeLiteral<org.apache.hadoop.shaded.com.google.common.base.Optional<T>> optionalOf(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(org.apache.hadoop.shaded.com.google.common.base.Optional.class, new Type[]{type.getType()}));
    }

    static <T> TypeLiteral<Optional<T>> javaOptionalOf(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{type.getType()}));
    }

    static <T> TypeLiteral<org.apache.hadoop.shaded.com.google.common.base.Optional<org.apache.hadoop.shaded.javax.inject.Provider<T>>> optionalOfJavaxProvider(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(org.apache.hadoop.shaded.com.google.common.base.Optional.class, new Type[]{Types.newParameterizedType(org.apache.hadoop.shaded.javax.inject.Provider.class, new Type[]{type.getType()})}));
    }

    static <T> TypeLiteral<Optional<org.apache.hadoop.shaded.javax.inject.Provider<T>>> javaOptionalOfJavaxProvider(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Types.newParameterizedType(org.apache.hadoop.shaded.javax.inject.Provider.class, new Type[]{type.getType()})}));
    }

    static <T> TypeLiteral<org.apache.hadoop.shaded.com.google.common.base.Optional<Provider<T>>> optionalOfProvider(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(org.apache.hadoop.shaded.com.google.common.base.Optional.class, new Type[]{Types.newParameterizedType(Provider.class, new Type[]{type.getType()})}));
    }

    static <T> TypeLiteral<Optional<Provider<T>>> javaOptionalOfProvider(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Types.newParameterizedType(Provider.class, new Type[]{type.getType()})}));
    }

    static <T> Key<Provider<T>> providerOf(Key<T> key) {
        ParameterizedType providerT = Types.providerOf(key.getTypeLiteral().getType());
        return key.ofType(providerT);
    }

    private RealOptionalBinder(Binder binder, Key<T> typeKey) {
        this.bindingSelection = new BindingSelection<T>(typeKey);
        this.binder = binder;
    }

    private void addDirectTypeBinding(Binder binder) {
        binder.bind(this.bindingSelection.getDirectKey()).toProvider(new RealDirectTypeProvider<T>(this.bindingSelection));
    }

    Key<T> getKeyForDefaultBinding() {
        this.bindingSelection.checkNotInitialized();
        this.addDirectTypeBinding(this.binder);
        return this.bindingSelection.getKeyForDefaultBinding();
    }

    public LinkedBindingBuilder<T> setDefault() {
        return this.binder.bind(this.getKeyForDefaultBinding());
    }

    Key<T> getKeyForActualBinding() {
        this.bindingSelection.checkNotInitialized();
        this.addDirectTypeBinding(this.binder);
        return this.bindingSelection.getKeyForActualBinding();
    }

    public LinkedBindingBuilder<T> setBinding() {
        return this.binder.bind(this.getKeyForActualBinding());
    }

    @Override
    public void configure(Binder binder) {
        this.bindingSelection.checkNotInitialized();
        Key<Object> key = this.bindingSelection.getDirectKey();
        TypeLiteral<T> typeLiteral = key.getTypeLiteral();
        RealOptionalProviderProvider<T> optionalProviderFactory = new RealOptionalProviderProvider<T>(this.bindingSelection);
        binder.bind(key.ofType(RealOptionalBinder.optionalOfProvider(typeLiteral))).toProvider(optionalProviderFactory);
        JavaOptionalProviderProvider<T> javaOptionalProviderFactory = new JavaOptionalProviderProvider<T>(this.bindingSelection);
        binder.bind(key.ofType(RealOptionalBinder.javaOptionalOfProvider(typeLiteral))).toProvider(javaOptionalProviderFactory);
        RealOptionalProviderProvider<T> optionalJavaxProviderFactory = optionalProviderFactory;
        binder.bind(key.ofType(RealOptionalBinder.optionalOfJavaxProvider(typeLiteral))).toProvider((Provider<org.apache.hadoop.shaded.com.google.common.base.Optional<org.apache.hadoop.shaded.javax.inject.Provider<T>>>)optionalJavaxProviderFactory);
        JavaOptionalProviderProvider<T> javaOptionalJavaxProviderFactory = javaOptionalProviderFactory;
        binder.bind(key.ofType(RealOptionalBinder.javaOptionalOfJavaxProvider(typeLiteral))).toProvider((Provider<Optional<org.apache.hadoop.shaded.javax.inject.Provider<T>>>)javaOptionalJavaxProviderFactory);
        Key<org.apache.hadoop.shaded.com.google.common.base.Optional<T>> optionalKey = key.ofType(RealOptionalBinder.optionalOf(typeLiteral));
        binder.bind(optionalKey).toProvider(new RealOptionalKeyProvider<T>(this.bindingSelection, optionalKey));
        Key<Optional<T>> javaOptionalKey = key.ofType(RealOptionalBinder.javaOptionalOf(typeLiteral));
        binder.bind(javaOptionalKey).toProvider(new JavaOptionalProvider<T>(this.bindingSelection, javaOptionalKey));
    }

    public boolean equals(Object o) {
        return o instanceof RealOptionalBinder && ((RealOptionalBinder)o).bindingSelection.equals(this.bindingSelection);
    }

    public int hashCode() {
        return this.bindingSelection.hashCode();
    }

    static abstract class BaseAnnotation
    implements Serializable,
    Annotation {
        private final String value;
        private final Class<? extends Annotation> clazz;
        private static final long serialVersionUID = 0L;

        BaseAnnotation(Class<? extends Annotation> clazz, String value) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        public String value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Actual && this.clazz == Actual.class) {
                Actual other = (Actual)o;
                return this.value.equals(other.value());
            }
            if (o instanceof Default && this.clazz == Default.class) {
                Default other = (Default)o;
                return this.value.equals(other.value());
            }
            return false;
        }

        @Override
        public String toString() {
            return "@" + this.clazz.getName() + (this.value.isEmpty() ? "" : "(value=" + this.value + ")");
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.clazz;
        }
    }

    static class ActualImpl
    extends BaseAnnotation
    implements Actual {
        public ActualImpl(String value) {
            super(Actual.class, value);
        }
    }

    static class DefaultImpl
    extends BaseAnnotation
    implements Default {
        public DefaultImpl(String value) {
            super(Default.class, value);
        }
    }

    private static abstract class RealOptionalBinderProviderWithDependencies<T, P>
    extends InternalProviderInstanceBindingImpl.Factory<P> {
        protected final BindingSelection<T> bindingSelection;

        RealOptionalBinderProviderWithDependencies(BindingSelection<T> bindingSelection) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.DELAYED);
            this.bindingSelection = bindingSelection;
        }

        @Override
        final void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
            this.bindingSelection.initialize(injector);
            this.doInitialize();
        }

        abstract void doInitialize();

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.bindingSelection.equals(((RealOptionalBinderProviderWithDependencies)obj).bindingSelection);
        }

        public int hashCode() {
            return this.bindingSelection.hashCode();
        }
    }

    private static final class BindingSelection<T> {
        private static final ImmutableSet<Dependency<?>> MODULE_DEPENDENCIES = ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
        BindingImpl<T> actualBinding;
        BindingImpl<T> defaultBinding;
        BindingImpl<T> binding;
        private boolean initialized;
        private final Key<T> key;
        private ImmutableSet<Dependency<?>> dependencies = MODULE_DEPENDENCIES;
        private ImmutableSet<Dependency<?>> providerDependencies = MODULE_DEPENDENCIES;
        private String bindingName;
        private Key<T> defaultBindingKey;
        private Key<T> actualBindingKey;

        BindingSelection(Key<T> key) {
            this.key = key;
        }

        void checkNotInitialized() {
            Errors.checkConfiguration(!this.initialized, "already initialized", new Object[0]);
        }

        void initialize(InjectorImpl injector) {
            if (this.initialized) {
                return;
            }
            this.actualBinding = injector.getExistingBinding((Key)this.getKeyForActualBinding());
            this.defaultBinding = injector.getExistingBinding((Key)this.getKeyForDefaultBinding());
            Binding userBinding = injector.getExistingBinding((Key)this.key);
            if (this.actualBinding != null) {
                this.binding = this.actualBinding;
            } else if (this.defaultBinding != null) {
                this.binding = this.defaultBinding;
            } else if (userBinding != null) {
                this.binding = userBinding;
                this.actualBinding = userBinding;
            }
            if (this.binding != null) {
                this.dependencies = ImmutableSet.of(Dependency.get(this.binding.getKey()));
                this.providerDependencies = ImmutableSet.of(Dependency.get(RealOptionalBinder.providerOf(this.binding.getKey())));
            } else {
                this.dependencies = ImmutableSet.of();
                this.providerDependencies = ImmutableSet.of();
            }
            this.initialized = true;
        }

        Key<T> getKeyForDefaultBinding() {
            if (this.defaultBindingKey == null) {
                this.defaultBindingKey = Key.get(this.key.getTypeLiteral(), (Annotation)new DefaultImpl(this.getBindingName()));
            }
            return this.defaultBindingKey;
        }

        Key<T> getKeyForActualBinding() {
            if (this.actualBindingKey == null) {
                this.actualBindingKey = Key.get(this.key.getTypeLiteral(), (Annotation)new ActualImpl(this.getBindingName()));
            }
            return this.actualBindingKey;
        }

        Key<T> getDirectKey() {
            return this.key;
        }

        private String getBindingName() {
            if (this.bindingName == null) {
                this.bindingName = Annotations.nameOf(this.key);
            }
            return this.bindingName;
        }

        BindingImpl<T> getBinding() {
            return this.binding;
        }

        BindingImpl<T> getDefaultBinding() {
            return this.defaultBinding;
        }

        BindingImpl<T> getActualBinding() {
            return this.actualBinding;
        }

        ImmutableSet<Dependency<?>> providerDependencies() {
            return this.providerDependencies;
        }

        ImmutableSet<Dependency<?>> dependencies() {
            return this.dependencies;
        }

        Dependency<?> getDependency() {
            return (Dependency)Iterables.getOnlyElement(this.dependencies);
        }

        boolean containsElement(Element element) {
            org.apache.hadoop.shaded.javax.inject.Provider providerInstance;
            if (element instanceof ProviderInstanceBinding && (providerInstance = ((ProviderInstanceBinding)element).getUserSuppliedProvider()) instanceof RealOptionalBinderProviderWithDependencies) {
                return ((RealOptionalBinderProviderWithDependencies)providerInstance).bindingSelection.equals(this);
            }
            if (element instanceof Binding) {
                Key elementKey = ((Binding)element).getKey();
                return elementKey.equals(this.getKeyForActualBinding()) || elementKey.equals(this.getKeyForDefaultBinding());
            }
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof BindingSelection && ((BindingSelection)o).key.equals(this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private static final class RealOptionalKeyProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, org.apache.hadoop.shaded.com.google.common.base.Optional<T>>
    implements ProviderWithExtensionVisitor<org.apache.hadoop.shaded.com.google.common.base.Optional<T>>,
    OptionalBinderBinding<org.apache.hadoop.shaded.com.google.common.base.Optional<T>> {
        private final Key<org.apache.hadoop.shaded.com.google.common.base.Optional<T>> optionalKey;
        private Dependency<?> targetDependency;
        private InternalFactory<? extends T> delegate;

        RealOptionalKeyProvider(BindingSelection<T> bindingSelection, Key<org.apache.hadoop.shaded.com.google.common.base.Optional<T>> optionalKey) {
            super(bindingSelection);
            this.optionalKey = optionalKey;
        }

        @Override
        void doInitialize() {
            if (this.bindingSelection.getBinding() != null) {
                this.delegate = this.bindingSelection.getBinding().getInternalFactory();
                this.targetDependency = this.bindingSelection.getDependency();
            }
        }

        @Override
        protected org.apache.hadoop.shaded.com.google.common.base.Optional<T> doProvision(InternalContext context, Dependency<?> currentDependency) throws InternalProvisionException {
            T result;
            InternalFactory<T> local = this.delegate;
            if (local == null) {
                return org.apache.hadoop.shaded.com.google.common.base.Optional.absent();
            }
            Dependency<?> localDependency = this.targetDependency;
            Dependency<?> previous = context.pushDependency(localDependency, this.getSource());
            try {
                result = local.get(context, localDependency, false);
            }
            catch (InternalProvisionException ipe) {
                throw ipe.addSource(localDependency);
            }
            finally {
                context.popStateAndSetDependency(previous);
            }
            return org.apache.hadoop.shaded.com.google.common.base.Optional.fromNullable(result);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies();
        }

        @Override
        public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> visitor, ProviderInstanceBinding<? extends B> binding) {
            if (visitor instanceof MultibindingsTargetVisitor) {
                return (R)((MultibindingsTargetVisitor)visitor).visit(this);
            }
            return visitor.visit(binding);
        }

        @Override
        public Key<org.apache.hadoop.shaded.com.google.common.base.Optional<T>> getKey() {
            return this.optionalKey;
        }

        @Override
        public Set<Key<?>> getAlternateKeys() {
            Key<Object> key = this.bindingSelection.getDirectKey();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            return ImmutableSet.of(key.ofType(RealOptionalBinder.optionalOfProvider(typeLiteral)), key.ofType(RealOptionalBinder.optionalOfJavaxProvider(typeLiteral)));
        }

        @Override
        public Binding<?> getActualBinding() {
            return this.bindingSelection.getActualBinding();
        }

        @Override
        public Binding<?> getDefaultBinding() {
            return this.bindingSelection.getDefaultBinding();
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }
    }

    private static final class RealOptionalProviderProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, org.apache.hadoop.shaded.com.google.common.base.Optional<Provider<T>>> {
        private org.apache.hadoop.shaded.com.google.common.base.Optional<Provider<T>> value;

        RealOptionalProviderProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            this.value = this.bindingSelection.getBinding() == null ? org.apache.hadoop.shaded.com.google.common.base.Optional.absent() : org.apache.hadoop.shaded.com.google.common.base.Optional.of(this.bindingSelection.getBinding().getProvider());
        }

        @Override
        protected org.apache.hadoop.shaded.com.google.common.base.Optional<Provider<T>> doProvision(InternalContext context, Dependency<?> dependency) {
            return this.value;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.providerDependencies();
        }
    }

    private static final class RealDirectTypeProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, T> {
        private Key<? extends T> targetKey;
        private Object targetSource;
        private InternalFactory<? extends T> targetFactory;

        RealDirectTypeProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            BindingImpl targetBinding = this.bindingSelection.getBinding();
            this.targetKey = targetBinding.getKey();
            this.targetSource = targetBinding.getSource();
            this.targetFactory = targetBinding.getInternalFactory();
        }

        @Override
        protected T doProvision(InternalContext context, Dependency<?> dependency) throws InternalProvisionException {
            context.pushState(this.targetKey, this.targetSource);
            try {
                T t = this.targetFactory.get(context, dependency, true);
                return t;
            }
            catch (InternalProvisionException ipe) {
                throw ipe.addSource(this.targetKey);
            }
            finally {
                context.popState();
            }
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies;
        }
    }

    private static final class JavaOptionalProviderProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, Optional<Provider<T>>> {
        private Optional<Provider<T>> value;

        JavaOptionalProviderProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            this.value = this.bindingSelection.getBinding() == null ? Optional.empty() : Optional.of(this.bindingSelection.getBinding().getProvider());
        }

        @Override
        protected Optional<Provider<T>> doProvision(InternalContext context, Dependency<?> dependency) {
            return this.value;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.providerDependencies();
        }
    }

    private static final class JavaOptionalProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, Optional<T>>
    implements ProviderWithExtensionVisitor<Optional<T>>,
    OptionalBinderBinding<Optional<T>> {
        private final Key<Optional<T>> optionalKey;
        private Dependency<?> targetDependency;
        private InternalFactory<? extends T> target;

        JavaOptionalProvider(BindingSelection<T> bindingSelection, Key<Optional<T>> optionalKey) {
            super(bindingSelection);
            this.optionalKey = optionalKey;
        }

        @Override
        void doInitialize() {
            if (this.bindingSelection.getBinding() != null) {
                this.target = this.bindingSelection.getBinding().getInternalFactory();
                this.targetDependency = this.bindingSelection.getDependency();
            }
        }

        @Override
        protected Optional<T> doProvision(InternalContext context, Dependency<?> currentDependency) throws InternalProvisionException {
            T result;
            InternalFactory<T> local = this.target;
            if (local == null) {
                return Optional.empty();
            }
            Dependency<?> localDependency = this.targetDependency;
            Dependency<?> previous = context.pushDependency(localDependency, this.getSource());
            try {
                result = local.get(context, localDependency, false);
            }
            catch (InternalProvisionException ipe) {
                throw ipe.addSource(localDependency);
            }
            finally {
                context.popStateAndSetDependency(previous);
            }
            return Optional.ofNullable(result);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies;
        }

        @Override
        public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> visitor, ProviderInstanceBinding<? extends B> binding) {
            if (visitor instanceof MultibindingsTargetVisitor) {
                return (R)((MultibindingsTargetVisitor)visitor).visit(this);
            }
            return visitor.visit(binding);
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }

        @Override
        public Binding<?> getActualBinding() {
            return this.bindingSelection.getActualBinding();
        }

        @Override
        public Binding<?> getDefaultBinding() {
            return this.bindingSelection.getDefaultBinding();
        }

        @Override
        public Key<Optional<T>> getKey() {
            return this.optionalKey;
        }

        @Override
        public Set<Key<?>> getAlternateKeys() {
            Key key = this.bindingSelection.getDirectKey();
            TypeLiteral typeLiteral = key.getTypeLiteral();
            return ImmutableSet.of(key.ofType(RealOptionalBinder.javaOptionalOfProvider(typeLiteral)), key.ofType(RealOptionalBinder.javaOptionalOfJavaxProvider(typeLiteral)));
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Actual {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Default {
        public String value();
    }

    static enum Source {
        DEFAULT,
        ACTUAL;

    }
}

