/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.io.IOException;
import java.io.Reader;
import rx.Observer;
import rx.observables.SyncOnSubscribe;

public final class OnSubscribeReader
extends SyncOnSubscribe<Reader, String> {
    private final Reader reader;
    private final int size;

    public OnSubscribeReader(Reader reader, int size) {
        this.reader = reader;
        this.size = size;
    }

    protected Reader generateState() {
        return this.reader;
    }

    protected Reader next(Reader reader, Observer<? super String> observer) {
        char[] buffer = new char[this.size];
        try {
            int count = reader.read(buffer);
            if (count == -1) {
                observer.onCompleted();
            } else {
                observer.onNext((Object)String.valueOf(buffer, 0, count));
            }
        }
        catch (IOException e) {
            observer.onError((Throwable)e);
        }
        return reader;
    }
}

