/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.AbstractComparatorOrderingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.CompoundComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.FifoComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.PriorityComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.RecoveryComparator;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;

public class FifoOrderingPolicyForPendingApps<S extends SchedulableEntity>
extends AbstractComparatorOrderingPolicy<S> {
    public FifoOrderingPolicyForPendingApps() {
        ArrayList<Comparator<SchedulableEntity>> comparators = new ArrayList<Comparator<SchedulableEntity>>();
        comparators.add(new RecoveryComparator());
        comparators.add(new PriorityComparator());
        comparators.add(new FifoComparator());
        this.comparator = new CompoundComparator(comparators);
        this.schedulableEntities = new ConcurrentSkipListSet(this.comparator);
    }

    @Override
    public String getInfo() {
        return "FifoOrderingPolicyForPendingApps";
    }

    @Override
    public String getConfigName() {
        return "fifo-for-pending-apps";
    }

    @Override
    public void configure(Map<String, String> conf) {
    }

    @Override
    public void containerAllocated(S schedulableEntity, RMContainer r) {
    }

    @Override
    public void containerReleased(S schedulableEntity, RMContainer r) {
    }

    @Override
    public void demandUpdated(S schedulableEntity) {
    }
}

