/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.constraint.PlacementConstraintManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class PlacementConstraintManagerService
extends AbstractService
implements PlacementConstraintManager {
    protected static final Logger LOG = LoggerFactory.getLogger(PlacementConstraintManagerService.class);
    private PlacementConstraintManager placementConstraintManager = null;

    public PlacementConstraintManagerService() {
        super(PlacementConstraintManagerService.class.getName());
    }

    @Override
    public boolean validateConstraint(Set<String> sourceTags, PlacementConstraint placementConstraint) {
        return this.validateSourceTags(sourceTags);
    }

    protected boolean validateSourceTags(Set<String> sourceTags) {
        if (sourceTags.isEmpty()) {
            LOG.warn("A placement constraint cannot be associated with an empty set of tags.");
            return false;
        }
        if (sourceTags.size() > 1) {
            LOG.warn("Only a single tag can be associated with a placement constraint currently.");
            return false;
        }
        return true;
    }

    protected String getValidSourceTag(Set<String> sourceTags) {
        return sourceTags.iterator().next();
    }
}

