/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webapp;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;

public class WrappedLogMetaRequest {
    private final LogAggregationFileControllerFactory factory;
    private final ApplicationId appId;
    private final String appOwner;
    private final ContainerId containerId;
    private final String nodeId;
    private final ApplicationAttemptId applicationAttemptId;

    private WrappedLogMetaRequest(Builder builder) {
        this.factory = builder.factory;
        this.appId = builder.appId;
        this.appOwner = builder.appOwner;
        this.containerId = builder.containerId;
        this.nodeId = builder.nodeId;
        this.applicationAttemptId = builder.applicationAttemptId;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String getAppId(ApplicationId appId, ApplicationAttemptId applicationAttemptId, ContainerId containerId) {
        if (appId == null) {
            if (applicationAttemptId == null) {
                return containerId.getApplicationAttemptId().getApplicationId().toString();
            }
            return applicationAttemptId.getApplicationId().toString();
        }
        return appId.toString();
    }

    public String getAppId() {
        return WrappedLogMetaRequest.getAppId(this.appId, this.applicationAttemptId, this.containerId);
    }

    public String getAppAttemptId() {
        if (this.applicationAttemptId == null) {
            if (this.containerId != null) {
                return this.containerId.getApplicationAttemptId().toString();
            }
            return null;
        }
        return this.applicationAttemptId.toString();
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public List<ContainerLogMeta> getContainerLogMetas() throws IOException {
        ApplicationId applicationId = ApplicationId.fromString((String)this.getAppId());
        ContainerLogsRequest request = new ContainerLogsRequest();
        request.setAppId(applicationId);
        request.setAppAttemptId(this.applicationAttemptId);
        if (this.containerId != null) {
            request.setContainerId(this.containerId.toString());
        }
        request.setAppOwner(this.appOwner);
        request.setNodeId(this.nodeId);
        return this.factory.getFileControllerForRead(applicationId, this.appOwner).readAggregatedLogsMeta(request);
    }

    public static class Builder {
        private LogAggregationFileControllerFactory factory;
        private ApplicationId appId;
        private String appOwner;
        private ContainerId containerId;
        private String nodeId;
        private ApplicationAttemptId applicationAttemptId;

        Builder() {
        }

        Builder setFactory(LogAggregationFileControllerFactory logFactory) {
            this.factory = logFactory;
            return this;
        }

        public Builder setApplicationId(ApplicationId applicationId) {
            this.appId = applicationId;
            return this;
        }

        Builder setNodeId(String nid) {
            this.nodeId = nid;
            return this;
        }

        public Builder setContainerId(@Nullable String containerIdStr) {
            if (containerIdStr != null) {
                this.containerId = ContainerId.fromString((String)containerIdStr);
            }
            return this;
        }

        Builder setAppOwner(String user) {
            this.appOwner = user;
            return this;
        }

        public Builder setApplicationAttemptId(ApplicationAttemptId appAttemptId) {
            this.applicationAttemptId = appAttemptId;
            return this;
        }

        String getAppId() {
            return WrappedLogMetaRequest.getAppId(this.appId, this.applicationAttemptId, this.containerId);
        }

        WrappedLogMetaRequest build() {
            if (this.factory == null) {
                throw new AssertionError((Object)"WrappedLogMetaRequest's builder should be given a LogAggregationFileControllerFactory as parameter.");
            }
            return new WrappedLogMetaRequest(this);
        }
    }
}

