/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.sql;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.sql.FederationSQLOutParameter;
import org.apache.hadoop.yarn.server.federation.store.sql.ResultSetHandler;
import org.apache.hadoop.yarn.server.federation.store.utils.FederationStateStoreUtils;
import org.apache.hadoop.yarn.util.Records;

public class RouterMasterKeyHandler
implements ResultSetHandler<RouterMasterKey> {
    private static final String MASTERKEY_OUT = "masterKey_OUT";

    @Override
    public RouterMasterKey handle(Object ... params) throws SQLException {
        RouterMasterKey routerMasterKey = (RouterMasterKey)Records.newRecord(RouterMasterKey.class);
        for (Object param : params) {
            if (!(param instanceof FederationSQLOutParameter)) continue;
            FederationSQLOutParameter parameter = (FederationSQLOutParameter)param;
            String paramName = parameter.getParamName();
            Object parmaValue = parameter.getValue();
            if (!StringUtils.equalsIgnoreCase((String)paramName, (String)MASTERKEY_OUT)) continue;
            DelegationKey key = this.getDelegationKey(parmaValue);
            routerMasterKey.setKeyId(key.getKeyId());
            routerMasterKey.setKeyBytes(ByteBuffer.wrap(key.getEncodedKey()));
            routerMasterKey.setExpiryDate(key.getExpiryDate());
        }
        return routerMasterKey;
    }

    private DelegationKey getDelegationKey(Object paramMasterKey) throws SQLException {
        try {
            DelegationKey key = new DelegationKey();
            String masterKey = String.valueOf(paramMasterKey);
            FederationStateStoreUtils.decodeWritable((Writable)key, masterKey);
            return key;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }
}

