/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.ImageServlet;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGetImageServlet {
    @Test
    public void testIsValidRequestor() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        KerberosName.setRules((String)"RULE:[1:$1]\nRULE:[2:$1]");
        conf.set("dfs.nameservices", "ns1");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.ha.namenodes", (String[])new String[]{"ns1"}), "nn1,nn2");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn1"}), "host1:1234");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.kerberos.principal", (String[])new String[]{"ns1", "nn1"}), "hdfs/_HOST@TEST-REALM.COM");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.rpc-address", (String[])new String[]{"ns1", "nn2"}), "host2:1234");
        conf.set(DFSUtil.addKeySuffixes((String)"dfs.namenode.kerberos.principal", (String[])new String[]{"ns1", "nn2"}), "hdfs/_HOST@TEST-REALM.COM");
        NameNode.initializeGenericKeys((Configuration)conf, (String)"ns1", (String)"nn1");
        AccessControlList acls = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.any())).thenReturn((Object)false);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("admins.acl")).thenReturn((Object)acls);
        Assert.assertTrue((boolean)ImageServlet.isValidRequestor((ServletContext)context, (String)"hdfs/host2@TEST-REALM.COM", (Configuration)conf));
        Mockito.when((Object)acls.isUserAllowed((UserGroupInformation)Mockito.argThat(ugi -> ugi.getShortUserName().equals("atm")))).thenReturn((Object)true);
        Assert.assertTrue((boolean)ImageServlet.isValidRequestor((ServletContext)context, (String)"hdfs/host2@TEST-REALM.COM", (Configuration)conf));
        Assert.assertTrue((boolean)ImageServlet.isValidRequestor((ServletContext)context, (String)"atm@TEST-REALM.COM", (Configuration)conf));
        Assert.assertFalse((boolean)ImageServlet.isValidRequestor((ServletContext)context, (String)"todd@TEST-REALM.COM", (Configuration)conf));
    }
}

