/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestDFSRemove {
    final Path dir = new Path("/test/remove/");

    void list(FileSystem fs, String name) throws IOException {
        FileSystem.LOG.info("\n\n" + name);
        for (FileStatus s : fs.listStatus(this.dir)) {
            FileSystem.LOG.info("" + s.getPath());
        }
    }

    static void createFile(FileSystem fs, Path f) throws IOException {
        FSDataOutputStream a_out = fs.create(f);
        a_out.writeBytes("something");
        a_out.close();
    }

    static long getTotalDfsUsed(MiniDFSCluster cluster) throws IOException {
        long total = 0L;
        for (DataNode node : cluster.getDataNodes()) {
            total += DataNodeTestUtils.getFSDataset(node).getDfsUsed();
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemove() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Assert.assertTrue((boolean)fs.mkdirs(this.dir));
            long dfsUsedStart = TestDFSRemove.getTotalDfsUsed(cluster);
            int fileCount = 100;
            for (int i = 0; i < 100; ++i) {
                Path a = new Path(this.dir, "a" + i);
                TestDFSRemove.createFile((FileSystem)fs, a);
            }
            long dfsUsedMax = TestDFSRemove.getTotalDfsUsed(cluster);
            for (int i = 0; i < 100; ++i) {
                Path a = new Path(this.dir, "a" + i);
                fs.delete(a, false);
            }
            Thread.sleep(9000L);
            long dfsUsedFinal = TestDFSRemove.getTotalDfsUsed(cluster);
            Assert.assertEquals((String)("All blocks should be gone. start=" + dfsUsedStart + " max=" + dfsUsedMax + " final=" + dfsUsedFinal), (long)dfsUsedStart, (long)dfsUsedFinal);
            fs.delete(this.dir, true);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

