/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;

public final class OperatorElementAt<T>
implements Observable.Operator<T, T> {
    final int index;
    final boolean hasDefault;
    final T defaultValue;

    public OperatorElementAt(int index) {
        this(index, null, false);
    }

    public OperatorElementAt(int index, T defaultValue) {
        this(index, defaultValue, true);
    }

    private OperatorElementAt(int index, T defaultValue, boolean hasDefault) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(index + " is out of bounds");
        }
        this.index = index;
        this.defaultValue = defaultValue;
        this.hasDefault = hasDefault;
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        Subscriber parent = new Subscriber<T>(){
            private int currentIndex;

            @Override
            public void onNext(T value) {
                if (this.currentIndex++ == OperatorElementAt.this.index) {
                    child.onNext(value);
                    child.onCompleted();
                    this.unsubscribe();
                }
            }

            @Override
            public void onError(Throwable e) {
                child.onError(e);
            }

            @Override
            public void onCompleted() {
                if (this.currentIndex <= OperatorElementAt.this.index) {
                    if (OperatorElementAt.this.hasDefault) {
                        child.onNext(OperatorElementAt.this.defaultValue);
                        child.onCompleted();
                    } else {
                        child.onError(new IndexOutOfBoundsException(OperatorElementAt.this.index + " is out of bounds"));
                    }
                }
            }

            @Override
            public void setProducer(Producer p) {
                child.setProducer(new InnerProducer(p));
            }
        };
        child.add(parent);
        return parent;
    }

    static class InnerProducer
    extends AtomicBoolean
    implements Producer {
        private static final long serialVersionUID = 1L;
        final Producer actual;

        public InnerProducer(Producer actual) {
            this.actual = actual;
        }

        @Override
        public void request(long n) {
            if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required");
            }
            if (n > 0L && this.compareAndSet(false, true)) {
                this.actual.request(Long.MAX_VALUE);
            }
        }
    }
}

