/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGContext;
import org.apache.hadoop.yarn.server.globalpolicygenerator.GPGUtils;
import org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator.GlobalPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyGenerator
implements Runnable,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyGenerator.class);
    private GPGContext gpgContext;
    private Configuration conf;
    private Map<Class, String> pathMap = new HashMap<Class, String>();
    @VisibleForTesting
    private GlobalPolicy policy;

    public PolicyGenerator(Configuration conf, GPGContext context) {
        this.setConf(conf);
        this.init(context);
    }

    private void init(GPGContext context) {
        this.gpgContext = context;
        LOG.info("Initialized PolicyGenerator");
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.policy = (GlobalPolicy)FederationStateStoreFacade.createInstance((Configuration)conf, (String)"yarn.federation.gpg.policy.generator.class", (String)"org.apache.hadoop.yarn.server.globalpolicygenerator.policygenerator.NoOpGlobalPolicy", GlobalPolicy.class);
        this.policy.setConf(conf);
        this.pathMap.putAll(this.policy.registerPaths());
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public final void run() {
        Map activeSubClusters;
        try {
            activeSubClusters = this.gpgContext.getStateStoreFacade().getSubClusters(true);
        }
        catch (YarnException e) {
            LOG.error("Error retrieving active sub-clusters", (Throwable)e);
            return;
        }
        Map<SubClusterId, SchedulerInfo> schedInfo = this.getSchedulerInfo(activeSubClusters);
        Set<String> queueNames = this.extractQueues(schedInfo);
        activeSubClusters.keySet().removeAll(this.getBlackList());
        LOG.info("Active non-blacklist sub-clusters: {}", activeSubClusters.keySet());
        Map<SubClusterId, Map<Class, Object>> clusterInfo = this.getInfos(activeSubClusters);
        for (String queueName : queueNames) {
            FederationPolicyManager manager;
            try {
                manager = this.gpgContext.getPolicyFacade().getPolicyManager(queueName);
            }
            catch (YarnException e) {
                LOG.error("GetPolicy for queue {} failed.", (Object)queueName, (Object)e);
                continue;
            }
            LOG.info("Updating policy for queue {}.", (Object)queueName);
            manager = this.policy.updatePolicy(queueName, clusterInfo, manager);
            try {
                this.gpgContext.getPolicyFacade().setPolicyManager(manager);
            }
            catch (YarnException e) {
                LOG.error("SetPolicy for queue {} failed.", (Object)queueName, (Object)e);
            }
        }
    }

    @VisibleForTesting
    protected Map<SubClusterId, Map<Class, Object>> getInfos(Map<SubClusterId, SubClusterInfo> activeSubClusters) {
        HashMap<SubClusterId, Map<Class, Object>> clusterInfo = new HashMap<SubClusterId, Map<Class, Object>>();
        for (SubClusterInfo sci : activeSubClusters.values()) {
            for (Map.Entry<Class, String> e : this.pathMap.entrySet()) {
                if (!clusterInfo.containsKey(sci.getSubClusterId())) {
                    clusterInfo.put(sci.getSubClusterId(), new HashMap());
                }
                Object ret = GPGUtils.invokeRMWebService(sci.getRMWebServiceAddress(), e.getValue(), e.getKey(), this.conf);
                ((Map)clusterInfo.get(sci.getSubClusterId())).put(e.getKey(), ret);
            }
        }
        return clusterInfo;
    }

    @VisibleForTesting
    protected Map<SubClusterId, SchedulerInfo> getSchedulerInfo(Map<SubClusterId, SubClusterInfo> activeSubClusters) {
        HashMap<SubClusterId, SchedulerInfo> schedInfo = new HashMap<SubClusterId, SchedulerInfo>();
        for (SubClusterInfo sci : activeSubClusters.values()) {
            SchedulerTypeInfo sti = GPGUtils.invokeRMWebService(sci.getRMWebServiceAddress(), "/scheduler", SchedulerTypeInfo.class, this.conf);
            if (sti != null) {
                schedInfo.put(sci.getSubClusterId(), sti.getSchedulerInfo());
                continue;
            }
            LOG.warn("Skipped null scheduler info from SubCluster {}.", (Object)sci.getSubClusterId());
        }
        return schedInfo;
    }

    private Set<SubClusterId> getBlackList() {
        String blackListParam = this.conf.get("yarn.federation.gpg.policy.generator.blacklist");
        if (blackListParam == null) {
            return Collections.emptySet();
        }
        HashSet<SubClusterId> blackList = new HashSet<SubClusterId>();
        for (String id : blackListParam.split(",")) {
            blackList.add(SubClusterId.newInstance((String)id));
        }
        return blackList;
    }

    private Set<String> extractQueues(Map<SubClusterId, SchedulerInfo> schedInfo) {
        HashSet<String> queueNames = new HashSet<String>();
        for (Map.Entry<SubClusterId, SchedulerInfo> entry : schedInfo.entrySet()) {
            if (entry.getValue() instanceof CapacitySchedulerInfo) {
                queueNames.addAll((Collection<String>)this.flattenQueue((CapacitySchedulerInfo)entry.getValue()).get(CapacitySchedulerQueueInfo.class));
                continue;
            }
            LOG.warn("Skipping SubCluster {}, not configured with capacity scheduler.", (Object)entry.getKey());
        }
        return queueNames;
    }

    private Map<Class, Set<String>> flattenQueue(CapacitySchedulerInfo csi) {
        HashMap<Class, Set<String>> flattened = new HashMap<Class, Set<String>>();
        this.addOrAppend(flattened, csi.getClass(), csi.getQueueName());
        for (CapacitySchedulerQueueInfo csqi : csi.getQueues().getQueueInfoList()) {
            this.flattenQueue(csqi, flattened);
        }
        return flattened;
    }

    private void flattenQueue(CapacitySchedulerQueueInfo csi, Map<Class, Set<String>> flattened) {
        this.addOrAppend(flattened, csi.getClass(), csi.getQueueName());
        if (csi.getQueues() != null) {
            for (CapacitySchedulerQueueInfo csqi : csi.getQueues().getQueueInfoList()) {
                this.flattenQueue(csqi, flattened);
            }
        }
    }

    private <K, V> void addOrAppend(Map<K, Set<V>> multimap, K key, V value) {
        if (!multimap.containsKey(key)) {
            multimap.put(key, new HashSet());
        }
        multimap.get(key).add(value);
    }

    public GlobalPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(GlobalPolicy policy) {
        this.policy = policy;
    }
}

