/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreCacheUpdateService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreCacheUpdateService.class);
    private final StateStoreService stateStore;

    public StateStoreCacheUpdateService(StateStoreService stateStore) {
        super(StateStoreCacheUpdateService.class.getSimpleName());
        this.stateStore = stateStore;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.setIntervalMs(conf.getTimeDuration("dfs.federation.router.cache.ttl", RBFConfigKeys.DFS_ROUTER_CACHE_TIME_TO_LIVE_MS_DEFAULT, TimeUnit.MILLISECONDS));
        super.serviceInit(conf);
    }

    @Override
    public void periodicInvoke() {
        LOG.debug("Updating State Store cache");
        this.stateStore.refreshCaches();
    }
}

