/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.response;

import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.NFS3Response;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;

public class FSINFO3Response
extends NFS3Response {
    private final Nfs3FileAttributes postOpAttr;
    private final int rtmax;
    private final int rtpref;
    private final int rtmult;
    private final int wtmax;
    private final int wtpref;
    private final int wtmult;
    private final int dtpref;
    private final long maxFileSize;
    private final NfsTime timeDelta;
    private final int properties;

    public FSINFO3Response(int status) {
        this(status, new Nfs3FileAttributes(), 0, 0, 0, 0, 0, 0, 0, 0L, null, 0);
    }

    public FSINFO3Response(int status, Nfs3FileAttributes postOpAttr, int rtmax, int rtpref, int rtmult, int wtmax, int wtpref, int wtmult, int dtpref, long maxFileSize, NfsTime timeDelta, int properties) {
        super(status);
        this.postOpAttr = postOpAttr;
        this.rtmax = rtmax;
        this.rtpref = rtpref;
        this.rtmult = rtmult;
        this.wtmax = wtmax;
        this.wtpref = wtpref;
        this.wtmult = wtmult;
        this.dtpref = dtpref;
        this.maxFileSize = maxFileSize;
        this.timeDelta = timeDelta;
        this.properties = properties;
    }

    public static FSINFO3Response deserialize(XDR xdr) {
        int status = xdr.readInt();
        xdr.readBoolean();
        Nfs3FileAttributes postOpObjAttr = Nfs3FileAttributes.deserialize(xdr);
        int rtmax = 0;
        int rtpref = 0;
        int rtmult = 0;
        int wtmax = 0;
        int wtpref = 0;
        int wtmult = 0;
        int dtpref = 0;
        long maxFileSize = 0L;
        NfsTime timeDelta = null;
        int properties = 0;
        if (status == 0) {
            rtmax = xdr.readInt();
            rtpref = xdr.readInt();
            rtmult = xdr.readInt();
            wtmax = xdr.readInt();
            wtpref = xdr.readInt();
            wtmult = xdr.readInt();
            dtpref = xdr.readInt();
            maxFileSize = xdr.readHyper();
            timeDelta = NfsTime.deserialize(xdr);
            properties = xdr.readInt();
        }
        return new FSINFO3Response(status, postOpObjAttr, rtmax, rtpref, rtmult, wtmax, wtpref, wtmult, dtpref, maxFileSize, timeDelta, properties);
    }

    @Override
    public XDR serialize(XDR out, int xid, Verifier verifier) {
        super.serialize(out, xid, verifier);
        out.writeBoolean(true);
        this.postOpAttr.serialize(out);
        if (this.getStatus() == 0) {
            out.writeInt(this.rtmax);
            out.writeInt(this.rtpref);
            out.writeInt(this.rtmult);
            out.writeInt(this.wtmax);
            out.writeInt(this.wtpref);
            out.writeInt(this.wtmult);
            out.writeInt(this.dtpref);
            out.writeLongAsHyper(this.maxFileSize);
            this.timeDelta.serialize(out);
            out.writeInt(this.properties);
        }
        return out;
    }
}

