/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.provider;

import java.io.IOException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.ConfigFile;
import org.apache.hadoop.yarn.service.utils.ServiceUtils;

public abstract class AbstractClientProvider {
    public static final Set<String> createApplicationTags(String appName, String appVersion, String appDescription) {
        HashSet<String> tags = new HashSet<String>();
        tags.add(ServiceUtils.createNameTag(appName));
        if (appVersion != null) {
            tags.add(ServiceUtils.createVersionTag(appVersion));
        }
        if (appDescription != null) {
            tags.add(ServiceUtils.createDescriptionTag(appDescription));
        }
        return tags;
    }

    public abstract void validateArtifact(Artifact var1, String var2, FileSystem var3) throws IOException;

    protected abstract void validateConfigFile(ConfigFile var1, String var2, FileSystem var3) throws IOException;

    public void validateConfigFiles(List<ConfigFile> configFiles, String compName, FileSystem fs) throws IOException {
        HashSet<String> destFileSet = new HashSet<String>();
        for (ConfigFile file : configFiles) {
            Path p;
            if (file.getType() == null) {
                throw new IllegalArgumentException("File type is empty");
            }
            ConfigFile.TypeEnum fileType = file.getType();
            if (fileType.equals((Object)ConfigFile.TypeEnum.TEMPLATE)) {
                if (StringUtils.isEmpty((CharSequence)file.getSrcFile()) && !file.getProperties().containsKey("content")) {
                    throw new IllegalArgumentException(MessageFormat.format("For {0} format, either src_file must be specified in ConfigFile, or the \"{1}\" key must be specified in the 'properties' field of ConfigFile. ", new Object[]{ConfigFile.TypeEnum.TEMPLATE, "content"}));
                }
            } else if (fileType.equals((Object)ConfigFile.TypeEnum.STATIC) || fileType.equals((Object)ConfigFile.TypeEnum.ARCHIVE)) {
                if (!file.getProperties().isEmpty()) {
                    throw new IllegalArgumentException(String.format("For %s format, should not specify any 'properties.'", new Object[]{fileType}));
                }
                String srcFile = file.getSrcFile();
                if (srcFile == null || srcFile.isEmpty()) {
                    throw new IllegalArgumentException(String.format("For %s format, should make sure that srcFile is specified", new Object[]{fileType}));
                }
                FileStatus fileStatus = fs.getFileStatus(new Path(srcFile));
                if (fileStatus != null && fileStatus.isDirectory()) {
                    throw new IllegalArgumentException("srcFile=" + srcFile + " is a directory, which is not supported.");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)file.getSrcFile()) && !fs.exists(p = new Path(file.getSrcFile()))) {
                throw new IllegalArgumentException("Specified src_file does not exist on " + fs.getScheme() + ": " + file.getSrcFile());
            }
            if (StringUtils.isEmpty((CharSequence)file.getDestFile())) {
                throw new IllegalArgumentException("dest_file is empty.");
            }
            if (destFileSet.contains(file.getDestFile())) {
                throw new IllegalArgumentException("Duplicated ConfigFile exists: " + file.getDestFile());
            }
            destFileSet.add(file.getDestFile());
            java.nio.file.Path destPath = Paths.get(file.getDestFile(), new String[0]);
            if (!destPath.isAbsolute() && destPath.getNameCount() > 1) {
                throw new IllegalArgumentException("Non-absolute dest_file has more than one path element");
            }
            this.validateConfigFile(file, compName, fs);
        }
    }
}

