/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.enums;

import org.apache.hadoop.fs.azurebfs.enums.StatisticTypeEnum;

public enum AbfsReadFooterMetricsEnum {
    TOTAL_FILES("totalFiles", "Total files read", "FILE", StatisticTypeEnum.TYPE_COUNTER),
    AVG_FILE_LENGTH("avgFileLength", "Average File length", "FILE", StatisticTypeEnum.TYPE_MEAN),
    AVG_SIZE_READ_BY_FIRST_READ("avgSizeReadByFirstRead", "Average Size read by first read", "FILE", StatisticTypeEnum.TYPE_MEAN),
    AVG_OFFSET_DIFF_BETWEEN_FIRST_AND_SECOND_READ("avgOffsetDiffBetweenFirstAndSecondRead", "Average Offset difference between first and second read", "FILE", StatisticTypeEnum.TYPE_MEAN),
    AVG_READ_LEN_REQUESTED("avgReadLenRequested", "Average Read length requested", "FILE", StatisticTypeEnum.TYPE_MEAN),
    AVG_FIRST_OFFSET_DIFF("avgFirstOffsetDiff", "Average First offset difference", "FILE", StatisticTypeEnum.TYPE_MEAN),
    AVG_SECOND_OFFSET_DIFF("avgSecondOffsetDiff", "Average Second offset difference", "FILE", StatisticTypeEnum.TYPE_MEAN);

    private final String name;
    private final String description;
    private final String type;
    private final StatisticTypeEnum statisticType;

    private AbfsReadFooterMetricsEnum(String name, String description, String type, StatisticTypeEnum statisticType) {
        this.name = name;
        this.description = description;
        this.type = type;
        this.statisticType = statisticType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public StatisticTypeEnum getStatisticType() {
        return this.statisticType;
    }
}

