/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import java.util.Arrays;
import org.ojalgo.array.ArrayAnyD;
import org.ojalgo.array.DenseArray;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.tensor.Tensor;

final class AnyTensor<N extends Number>
implements Tensor<N> {
    private final ArrayAnyD<N> myArray;
    private final DenseArray.Factory<N> myArrayFactory;
    private final int myDimensions;
    private final int myRank;

    AnyTensor(int rank, int dimensions, DenseArray.Factory<N> arrayFactory) {
        this.myRank = rank;
        this.myDimensions = dimensions;
        long[] shape = new long[rank];
        Arrays.fill(shape, (long)dimensions);
        this.myArray = ArrayAnyD.factory(arrayFactory).makeZero(shape);
        this.myArrayFactory = arrayFactory;
    }

    @Override
    public Tensor<N> add(Tensor<N> addend) {
        AnyTensor<N> retVal = new AnyTensor<N>(this.myRank, this.myDimensions, this.myArrayFactory);
        ArrayAnyD<N> retArray = retVal.getArray();
        retArray.loopAll((long i) -> retArray.set(i, this.doubleValue(i) + addend.doubleValue(i)));
        return retVal;
    }

    @Override
    public Tensor<N> conjugate() {
        AnyTensor<N> retVal = new AnyTensor<N>(this.myRank, this.myDimensions, this.myArrayFactory);
        ArrayAnyD<N> retArray = retVal.getArray();
        long[] traspRef = (long[])retVal.shape().clone();
        long max = (long)this.myDimensions - 1L;
        retArray.loopAll((long[] ref) -> {
            for (int i = 0; i < traspRef.length; ++i) {
                traspRef[i] = max - ref[i];
            }
            retArray.set(traspRef, this.myArray.doubleValue(ref));
        });
        return retVal;
    }

    @Override
    public long count() {
        return (long)Math.pow(this.myDimensions, this.myRank);
    }

    @Override
    public int dimensions() {
        return this.myDimensions;
    }

    @Override
    public double doubleValue(long[] ref) {
        return this.myArray.doubleValue(ref);
    }

    @Override
    public N get(long[] ref) {
        return this.myArray.get(ref);
    }

    @Override
    public boolean isSmall(double comparedTo) {
        return this.myArray.isAllSmall(comparedTo);
    }

    @Override
    public Tensor<N> multiply(double scalarMultiplicand) {
        AnyTensor<N> retVal = new AnyTensor<N>(this.myRank, this.myDimensions, this.myArrayFactory);
        ArrayAnyD<double> retArray = retVal.getArray();
        retArray.modifyAll(this.myArrayFactory.function().multiply().second(scalarMultiplicand));
        return retVal;
    }

    @Override
    public Tensor<N> multiply(N scalarMultiplicand) {
        AnyTensor<N> retVal = new AnyTensor<N>(this.myRank, this.myDimensions, this.myArrayFactory);
        ArrayAnyD retArray = retVal.getArray();
        retArray.modifyAll(this.myArrayFactory.function().multiply().second(scalarMultiplicand));
        return retVal;
    }

    @Override
    public Tensor<N> negate() {
        AnyTensor<N> retVal = new AnyTensor<N>(this.myRank, this.myDimensions, this.myArrayFactory);
        ArrayAnyD retArray = retVal.getArray();
        retArray.modifyAll(this.myArrayFactory.function().negate());
        return retVal;
    }

    @Override
    public double norm() {
        AggregatorFunction tmpNorm2 = this.myArrayFactory.aggregator().norm2();
        this.myArray.visitAll(tmpNorm2);
        return tmpNorm2.doubleValue();
    }

    @Override
    public int rank() {
        return this.myRank;
    }

    @Override
    public long[] shape() {
        return this.myArray.shape();
    }

    @Override
    public Tensor<N> signum() {
        return this.multiply(PrimitiveMath.ONE / this.norm());
    }

    ArrayAnyD<N> getArray() {
        return this.myArray;
    }
}

