/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.RandomNumber;
import org.ojalgo.random.RandomUtils;

public class Weibull
extends RandomNumber {
    private static final long serialVersionUID = 7315696913427382955L;
    private final double myShape;
    private final double myRate;

    public Weibull() {
        this(PrimitiveMath.ONE, PrimitiveMath.ONE);
    }

    public Weibull(double aLambda, double aBeta) {
        this.myRate = aLambda;
        this.myShape = aBeta;
    }

    @Override
    public double getExpected() {
        return RandomUtils.gamma(PrimitiveMath.ONE + PrimitiveMath.ONE / this.myShape) / this.myRate;
    }

    @Override
    public double getVariance() {
        double tmpA = RandomUtils.gamma(PrimitiveMath.ONE + PrimitiveMath.TWO / this.myShape);
        double tmpB = RandomUtils.gamma(PrimitiveMath.ONE + PrimitiveMath.ONE / this.myShape);
        return (tmpA - tmpB * tmpB) / (this.myRate * this.myRate);
    }

    @Override
    protected double generate() {
        return PrimitiveFunction.POW.invoke(-PrimitiveFunction.LOG.invoke(this.random().nextDouble()), PrimitiveMath.ONE / this.myShape) / this.myRate;
    }
}

