/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.function.ComplexFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.ComplexAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Scalar;

public class ComplexArray
extends ScalarArray<ComplexNumber> {
    public static final DenseArray.Factory<ComplexNumber> FACTORY = new DenseArray.Factory<ComplexNumber>(){

        @Override
        public AggregatorSet<ComplexNumber> aggregator() {
            return ComplexAggregator.getSet();
        }

        @Override
        public FunctionSet<ComplexNumber> function() {
            return ComplexFunction.getSet();
        }

        @Override
        public Scalar.Factory<ComplexNumber> scalar() {
            return ComplexNumber.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<ComplexNumber> make(long size) {
            return ComplexArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(ComplexNumber.class);

    public static final ComplexArray make(int size) {
        return new ComplexArray(size);
    }

    public static final ComplexArray wrap(ComplexNumber[] data) {
        return new ComplexArray(data);
    }

    protected ComplexArray(ComplexNumber[] data) {
        super((Number[])data);
    }

    protected ComplexArray(int size) {
        super((Number[])new ComplexNumber[size]);
        this.fill(0, size, 1, ComplexNumber.ZERO);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof ComplexArray) {
            return Arrays.equals(this.data, ((ComplexArray)anObj).data);
        }
        return super.equals(anObj);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((ComplexNumber[])this.data)[i] = ComplexNumber.valueOf(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])((Comparable[])this.data));
    }

    @Override
    public void sortDescending() {
        Arrays.parallelSort(this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((ComplexNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((ComplexNumber)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected boolean isAbsolute(int index) {
        return ComplexNumber.isAbsolute(((ComplexNumber[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return ComplexNumber.isSmall(comparedTo, ((ComplexNumber[])this.data)[index]);
    }

    @Override
    ComplexNumber valueOf(double value) {
        return ComplexNumber.valueOf(value);
    }

    @Override
    ComplexNumber valueOf(Number number) {
        return ComplexNumber.valueOf(number);
    }
}

