/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.blas.AMAX;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.function.aggregator.BigAggregator;
import org.ojalgo.machine.MemoryEstimator;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.TypeUtils;

public class BigArray
extends ReferenceTypeArray<BigDecimal> {
    public static final DenseArray.Factory<BigDecimal> FACTORY = new DenseArray.Factory<BigDecimal>(){

        @Override
        public AggregatorSet<BigDecimal> aggregator() {
            return BigAggregator.getSet();
        }

        @Override
        public FunctionSet<BigDecimal> function() {
            return BigFunction.getSet();
        }

        @Override
        public Scalar.Factory<BigDecimal> scalar() {
            return BigScalar.FACTORY;
        }

        @Override
        long getElementSize() {
            return ELEMENT_SIZE;
        }

        @Override
        PlainArray<BigDecimal> make(long size) {
            return BigArray.make((int)size);
        }
    };
    static final long ELEMENT_SIZE = MemoryEstimator.estimateObject(BigDecimal.class);

    public static final BigArray make(int size) {
        return new BigArray(size);
    }

    public static final BigArray wrap(BigDecimal[] data) {
        return new BigArray(data);
    }

    protected BigArray(BigDecimal[] data) {
        super((Number[])data);
    }

    protected BigArray(int size) {
        super((Number[])new BigDecimal[size]);
        this.fill(0, size, 1, BigMath.ZERO);
    }

    @Override
    public final void axpy(double a, Mutate1D y) {
        AXPY.invoke(y, a, (BigDecimal[])this.data);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof BigArray) {
            return Arrays.equals(this.data, ((BigArray)other).data);
        }
        return super.equals(other);
    }

    @Override
    public final void fillMatching(Access1D<?> values) {
        int tmpLimit = (int)FunctionUtils.min(this.count(), values.count());
        for (int i = 0; i < tmpLimit; ++i) {
            ((BigDecimal[])this.data)[i] = TypeUtils.toBigDecimal(values.get(i));
        }
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public final void sortAscending() {
        Arrays.parallelSort((Comparable[])((Comparable[])this.data));
    }

    @Override
    public void sortDescending() {
        Arrays.parallelSort(this.data, Comparator.reverseOrder());
    }

    @Override
    protected final void add(int index, double addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final void add(int index, Number addend) {
        this.fillOne(index, ((BigDecimal)this.get(index)).add(this.valueOf(addend)));
    }

    @Override
    protected final int indexOfLargest(int first, int limit, int step) {
        return AMAX.invoke((BigDecimal[])this.data, first, limit, step);
    }

    @Override
    protected boolean isAbsolute(int index) {
        return BigScalar.isAbsolute(((BigDecimal[])this.data)[index]);
    }

    @Override
    protected boolean isSmall(int index, double comparedTo) {
        return BigScalar.isSmall(comparedTo, ((BigDecimal[])this.data)[index]);
    }

    @Override
    BigDecimal valueOf(double value) {
        return BigDecimal.valueOf(value);
    }

    @Override
    BigDecimal valueOf(Number number) {
        return TypeUtils.toBigDecimal(number);
    }
}

