/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Times {
    private static final Logger LOG = LoggerFactory.getLogger(Times.class);
    static final String ISO8601_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss Z yyyy").withZone(ZoneId.systemDefault());
    static final DateTimeFormatter ISO_OFFSET_DATE_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZone(ZoneId.systemDefault());

    public static long elapsed(long started, long finished) {
        return Times.elapsed(started, finished, true);
    }

    public static long elapsed(long started, long finished, boolean isRunning) {
        if (finished > 0L && started > 0L) {
            long elapsed = finished - started;
            if (elapsed >= 0L) {
                return elapsed;
            }
            LOG.warn("Finished time " + finished + " is ahead of started time " + started);
            return -1L;
        }
        if (isRunning) {
            long elapsed;
            long current = System.currentTimeMillis();
            long l = elapsed = started > 0L ? current - started : 0L;
            if (elapsed >= 0L) {
                return elapsed;
            }
            LOG.warn("Current time " + current + " is ahead of started time " + started);
            return -1L;
        }
        return -1L;
    }

    public static String format(long ts) {
        return ts > 0L ? DATE_FORMAT.format(Instant.ofEpochMilli(ts)) : "N/A";
    }

    public static String formatISO8601(long ts) {
        return ISO_OFFSET_DATE_TIME.format(Instant.ofEpochMilli(ts));
    }

    public static long parseISO8601ToLocalTimeInMillis(String isoString) throws ParseException {
        if (isoString == null) {
            throw new ParseException("Invalid input.", -1);
        }
        return Instant.from(ISO_OFFSET_DATE_TIME.parse(isoString)).toEpochMilli();
    }
}

