/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.HttpOpParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRouterHttpDelegationToken {
    public static final String FILTER_INITIALIZER_PROPERTY = "hadoop.http.filter.initializers";
    private Router router;
    private WebHdfsFileSystem fs;

    @Before
    public void setup() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.set("dfs.federation.router.http-address", "0.0.0.0:0");
        conf.set("dfs.federation.router.https-address", "0.0.0.0:0");
        conf.set("dfs.federation.router.rpc-address", "0.0.0.0:0");
        conf.set(FILTER_INITIALIZER_PROPERTY, NoAuthFilterInitializer.class.getName());
        conf.set("hadoop.http.authentication.type", "simple");
        Configuration routerConf = new RouterConfigBuilder().rpc().http().build();
        conf.addResource(routerConf);
        this.router = new Router();
        this.router.init(conf);
        this.router.start();
        InetSocketAddress webAddress = this.router.getHttpServerAddress();
        URI webURI = new URI("swebhdfs", null, webAddress.getHostName(), webAddress.getPort(), null, null, null);
        this.fs = (WebHdfsFileSystem)FileSystem.get((URI)webURI, (Configuration)conf);
    }

    @After
    public void cleanup() throws Exception {
        if (this.router != null) {
            this.router.stop();
            this.router.close();
        }
        SecurityConfUtil.destroy();
    }

    @Test
    public void testGetDelegationToken() throws Exception {
        String renewer = "renewer0";
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(this.fs, "renewer0");
        Assert.assertNotNull(token);
        DelegationTokenIdentifier tokenId = this.getTokenIdentifier(token.getIdentifier());
        Assert.assertEquals((Object)"router", (Object)tokenId.getOwner().toString());
        Assert.assertEquals((Object)"renewer0", (Object)tokenId.getRenewer().toString());
        Assert.assertEquals((Object)"", (Object)tokenId.getRealUser().toString());
        Assert.assertEquals((Object)"SWEBHDFS delegation", (Object)token.getKind().toString());
        Assert.assertNotNull((Object)token.getPassword());
    }

    @Test
    public void testRenewDelegationToken() throws Exception {
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(this.fs, "router");
        DelegationTokenIdentifier tokenId = this.getTokenIdentifier(token.getIdentifier());
        long t = this.renewDelegationToken(this.fs, token);
        Assert.assertTrue((String)(t + " should not be larger than " + tokenId.getMaxDate()), (t <= tokenId.getMaxDate() ? 1 : 0) != 0);
    }

    @Test
    public void testCancelDelegationToken() throws Exception {
        Token<DelegationTokenIdentifier> token = this.getDelegationToken(this.fs, "router");
        this.cancelDelegationToken(this.fs, token);
        LambdaTestUtils.intercept(IOException.class, (String)"Server returned HTTP response code: 403 ", () -> this.renewDelegationToken(this.fs, token));
    }

    private Token<DelegationTokenIdentifier> getDelegationToken(WebHdfsFileSystem webHdfs, String renewer) throws IOException {
        Map<?, ?> json = this.sendHttpRequest(webHdfs, (HttpOpParam.Op)GetOpParam.Op.GETDELEGATIONTOKEN, new Param[]{new RenewerParam(renewer)});
        return WebHdfsTestUtil.convertJsonToDelegationToken(json);
    }

    private long renewDelegationToken(WebHdfsFileSystem webHdfs, Token<?> token) throws IOException {
        Map<?, ?> json = this.sendHttpRequest(webHdfs, (HttpOpParam.Op)PutOpParam.Op.RENEWDELEGATIONTOKEN, new Param[]{new TokenArgumentParam(token.encodeToUrlString())});
        return ((Number)json.get("long")).longValue();
    }

    private void cancelDelegationToken(WebHdfsFileSystem webHdfs, Token<?> token) throws IOException {
        this.sendHttpRequest(webHdfs, (HttpOpParam.Op)PutOpParam.Op.CANCELDELEGATIONTOKEN, new Param[]{new TokenArgumentParam(token.encodeToUrlString())});
    }

    private Map<?, ?> sendHttpRequest(WebHdfsFileSystem webHdfs, HttpOpParam.Op op, Param<?, ?> ... parameters) throws IOException {
        String user = SecurityConfUtil.getRouterUserName();
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add(new UserParam(user));
        pList.addAll(Arrays.asList(parameters));
        URL url = WebHdfsTestUtil.toUrl((WebHdfsFileSystem)webHdfs, (HttpOpParam.Op)op, null, (Param[])pList.toArray(new Param[pList.size()]));
        HttpURLConnection conn = WebHdfsTestUtil.openConnection((URL)url, (Configuration)webHdfs.getConf());
        conn.setRequestMethod(op.getType().toString());
        WebHdfsTestUtil.sendRequest((HttpURLConnection)conn);
        Map json = WebHdfsTestUtil.getAndParseResponse((HttpURLConnection)conn);
        conn.disconnect();
        return json;
    }

    private DelegationTokenIdentifier getTokenIdentifier(byte[] id) throws IOException {
        DelegationTokenIdentifier identifier = new DelegationTokenIdentifier();
        ByteArrayInputStream bais = new ByteArrayInputStream(id);
        DataInputStream dais = new DataInputStream(bais);
        identifier.readFields((DataInput)dais);
        return identifier;
    }

    public static final class NoAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties props = new Properties();
            Enumeration names = filterConfig.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(configPrefix)) continue;
                String value = filterConfig.getInitParameter(name);
                props.put(name.substring(configPrefix.length()), value);
            }
            props.put("type", "simple");
            props.put("simple.anonymous.allowed", "true");
            return props;
        }
    }

    public static final class NoAuthFilterInitializer
    extends AuthenticationFilterInitializer {
        static final String PREFIX = "hadoop.http.authentication.";

        public void initFilter(FilterContainer container, Configuration conf) {
            Map filterConfig = NoAuthFilterInitializer.getFilterConfigMap((Configuration)conf, (String)PREFIX);
            container.addFilter("authentication", NoAuthFilter.class.getName(), filterConfig);
        }
    }
}

