/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.http.HttpServer2;
import org.junit.Assert;
import org.junit.Test;

public class TestRouterHttpServerXFrame {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRouterXFrame() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.xframe.enabled", true);
        conf.set("dfs.xframe.value", HttpServer2.XFrameOption.SAMEORIGIN.toString());
        Router router = new Router();
        try {
            router.init((Configuration)conf);
            router.start();
            InetSocketAddress httpAddress = router.getHttpServerAddress();
            URL url = URI.create("http://" + httpAddress.getHostName() + ":" + httpAddress.getPort()).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
            Assert.assertNotNull((String)"X-FRAME-OPTIONS is absent in the header", (Object)xfoHeader);
            Assert.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
        }
        finally {
            router.stop();
            router.close();
        }
    }
}

