/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.ConnectorConfiguration;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryConfiguration;

public class ObjectClientConfiguration {
    public static final String DEFAULT_USER_AGENT_PREFIX = null;
    public static final String USER_AGENT_PREFIX_KEY = "useragentprefix";
    public static final String TELEMETRY_PREFIX = "telemetry";
    private String userAgentPrefix;
    @NonNull
    private TelemetryConfiguration telemetryConfiguration;
    public static final ObjectClientConfiguration DEFAULT = ObjectClientConfiguration.builder().build();

    public static ObjectClientConfiguration fromConfiguration(ConnectorConfiguration configuration) {
        return ObjectClientConfiguration.builder().userAgentPrefix(configuration.getString(USER_AGENT_PREFIX_KEY, DEFAULT_USER_AGENT_PREFIX)).telemetryConfiguration(TelemetryConfiguration.fromConfiguration(configuration.map(TELEMETRY_PREFIX))).build();
    }

    @Generated
    private static String $default$userAgentPrefix() {
        return DEFAULT_USER_AGENT_PREFIX;
    }

    @Generated
    private static TelemetryConfiguration $default$telemetryConfiguration() {
        return TelemetryConfiguration.DEFAULT;
    }

    @Generated
    ObjectClientConfiguration(String userAgentPrefix, @NonNull TelemetryConfiguration telemetryConfiguration) {
        if (telemetryConfiguration == null) {
            throw new NullPointerException("telemetryConfiguration is marked non-null but is null");
        }
        this.userAgentPrefix = userAgentPrefix;
        this.telemetryConfiguration = telemetryConfiguration;
    }

    @Generated
    public static ObjectClientConfigurationBuilder builder() {
        return new ObjectClientConfigurationBuilder();
    }

    @Generated
    public String getUserAgentPrefix() {
        return this.userAgentPrefix;
    }

    @NonNull
    @Generated
    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.telemetryConfiguration;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectClientConfiguration)) {
            return false;
        }
        ObjectClientConfiguration other = (ObjectClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userAgentPrefix = this.getUserAgentPrefix();
        String other$userAgentPrefix = other.getUserAgentPrefix();
        if (this$userAgentPrefix == null ? other$userAgentPrefix != null : !this$userAgentPrefix.equals(other$userAgentPrefix)) {
            return false;
        }
        TelemetryConfiguration this$telemetryConfiguration = this.getTelemetryConfiguration();
        TelemetryConfiguration other$telemetryConfiguration = other.getTelemetryConfiguration();
        return !(this$telemetryConfiguration == null ? other$telemetryConfiguration != null : !((Object)this$telemetryConfiguration).equals(other$telemetryConfiguration));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObjectClientConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userAgentPrefix = this.getUserAgentPrefix();
        result = result * 59 + ($userAgentPrefix == null ? 43 : $userAgentPrefix.hashCode());
        TelemetryConfiguration $telemetryConfiguration = this.getTelemetryConfiguration();
        result = result * 59 + ($telemetryConfiguration == null ? 43 : ((Object)$telemetryConfiguration).hashCode());
        return result;
    }

    @Generated
    public static class ObjectClientConfigurationBuilder {
        @Generated
        private boolean userAgentPrefix$set;
        @Generated
        private String userAgentPrefix$value;
        @Generated
        private boolean telemetryConfiguration$set;
        @Generated
        private TelemetryConfiguration telemetryConfiguration$value;

        @Generated
        ObjectClientConfigurationBuilder() {
        }

        @Generated
        public ObjectClientConfigurationBuilder userAgentPrefix(String userAgentPrefix) {
            this.userAgentPrefix$value = userAgentPrefix;
            this.userAgentPrefix$set = true;
            return this;
        }

        @Generated
        public ObjectClientConfigurationBuilder telemetryConfiguration(@NonNull TelemetryConfiguration telemetryConfiguration) {
            if (telemetryConfiguration == null) {
                throw new NullPointerException("telemetryConfiguration is marked non-null but is null");
            }
            this.telemetryConfiguration$value = telemetryConfiguration;
            this.telemetryConfiguration$set = true;
            return this;
        }

        @Generated
        public ObjectClientConfiguration build() {
            String userAgentPrefix$value = this.userAgentPrefix$value;
            if (!this.userAgentPrefix$set) {
                userAgentPrefix$value = ObjectClientConfiguration.$default$userAgentPrefix();
            }
            TelemetryConfiguration telemetryConfiguration$value = this.telemetryConfiguration$value;
            if (!this.telemetryConfiguration$set) {
                telemetryConfiguration$value = ObjectClientConfiguration.$default$telemetryConfiguration();
            }
            return new ObjectClientConfiguration(userAgentPrefix$value, telemetryConfiguration$value);
        }

        @Generated
        public String toString() {
            return "ObjectClientConfiguration.ObjectClientConfigurationBuilder(userAgentPrefix$value=" + this.userAgentPrefix$value + ", telemetryConfiguration$value=" + this.telemetryConfiguration$value + ")";
        }
    }
}

