/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen.datatypes;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.tools.rumen.datatypes.DefaultAnonymizableDataType;

public class ClassName
extends DefaultAnonymizableDataType {
    public static final String CLASSNAME_PRESERVE_CONFIG = "rumen.data-types.classname.preserve";
    private final String className;

    public ClassName(String className) {
        this.className = className;
    }

    @Override
    public String getValue() {
        return this.className;
    }

    @Override
    protected String getPrefix() {
        return "class";
    }

    @Override
    protected boolean needsAnonymization(Configuration conf) {
        String[] preserves = conf.getStrings(CLASSNAME_PRESERVE_CONFIG);
        if (preserves != null) {
            for (String p : preserves) {
                if (!this.className.startsWith(p)) continue;
                return false;
            }
        }
        return true;
    }
}

